/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

public final class XmlUtil {
    private XmlUtil() {
    }

    public static boolean needsEscape(String s, Context context) {
        if (s != null) {
            for (int index = 0; index < s.length(); ++index) {
                char c = s.charAt(index);
                switch (c) {
                    case '&': 
                    case '<': 
                    case '>': {
                        return true;
                    }
                    case '\"': {
                        return context == Context.ATTRIBUTE_DOUBLE_QUOTE;
                    }
                    case '\'': {
                        return context == Context.ATTRIBUTE_SINGLE_QUOTE;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public static String escape(String s, Context context) {
        if (s != null) {
            StringBuilder builder = new StringBuilder();
            block7: for (int index = 0; index < s.length(); ++index) {
                char c = s.charAt(index);
                switch (c) {
                    case '>': {
                        builder.append("&gt;");
                        continue block7;
                    }
                    case '<': {
                        builder.append("&lt;");
                        continue block7;
                    }
                    case '&': {
                        builder.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        if (context == Context.ATTRIBUTE_SINGLE_QUOTE) {
                            builder.append("&apos;");
                            continue block7;
                        }
                        builder.append(c);
                        continue block7;
                    }
                    case '\"': {
                        if (context == Context.ATTRIBUTE_DOUBLE_QUOTE) {
                            builder.append("&quot;");
                            continue block7;
                        }
                        builder.append(c);
                        continue block7;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            return builder.toString();
        }
        return s;
    }

    public static enum Context {
        ELEMENT,
        ATTRIBUTE_SINGLE_QUOTE,
        ATTRIBUTE_DOUBLE_QUOTE;

    }
}

