/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.compress.CompressionUtils;
import cdc.util.compress.Compressor;
import cdc.util.xml.AbstractStAXParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.function.Function;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStAXLoader<R> {
    private final Logger logger;
    private final Function<XMLStreamReader, ? extends AbstractStAXParser<R>> ctor;
    private static final String LOAD = "load({}, {})";

    protected AbstractStAXLoader(Function<XMLStreamReader, ? extends AbstractStAXParser<R>> ctor) {
        this.ctor = ctor;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R load(Reader reader) throws IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try (Reader buffered = reader instanceof BufferedReader ? reader : new BufferedReader(reader);){
            XMLStreamReader xmlsr = factory.createXMLStreamReader(buffered);
            AbstractStAXParser<R> parser = this.ctor.apply(xmlsr);
            R result = parser.parse();
            xmlsr.close();
            R r = result;
            return r;
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public R load(InputStream is) throws IOException {
        return this.load(is, null, Compressor.NONE);
    }

    public R load(InputStream is, String systemId) throws IOException {
        return this.load(is, systemId, Compressor.NONE);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public R load(InputStream is, String systemId, Compressor compressor) throws IOException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try (InputStream buffered = is instanceof BufferedInputStream ? is : new BufferedInputStream(is);){
            R r;
            block14: {
                InputStream adapted = CompressionUtils.adapt((InputStream)buffered, (Compressor)compressor);
                try {
                    XMLStreamReader xmlsr = factory.createXMLStreamReader(systemId, adapted);
                    AbstractStAXParser<R> parser = this.ctor.apply(xmlsr);
                    R result = parser.parse();
                    xmlsr.close();
                    r = result;
                    if (adapted == null) break block14;
                }
                catch (Throwable throwable) {
                    if (adapted != null) {
                        try {
                            adapted.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                adapted.close();
            }
            return r;
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public final R load(String filename, Compressor compressor) throws IOException {
        this.logger.info(LOAD, (Object)filename, (Object)compressor);
        try (BufferedInputStream is = new BufferedInputStream(CompressionUtils.adapt((InputStream)new FileInputStream(filename), (Compressor)compressor));){
            R r = this.load(is);
            return r;
        }
    }

    public final R load(String filename) throws IOException {
        return this.load(filename, Compressor.NONE);
    }

    public final R load(File file, Compressor compressor) throws IOException {
        return this.load(file.getPath(), compressor);
    }

    public final R load(File file) throws IOException {
        return this.load(file, Compressor.NONE);
    }

    public final R load(URL url, Compressor compressor) throws IOException {
        this.logger.info(LOAD, (Object)url, (Object)compressor);
        try (BufferedInputStream is = new BufferedInputStream(CompressionUtils.adapt((InputStream)url.openStream(), (Compressor)compressor));){
            R r = this.load(is);
            return r;
        }
    }

    public final R load(URL url) throws IOException {
        return this.load(url, Compressor.NONE);
    }
}

