/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.InvalidDataException;
import cdc.util.lang.NotFoundException;
import cdc.util.strings.StringConversion;
import cdc.util.xml.StAXSupport;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractStAXParser<R> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final XMLStreamReader reader;

    protected AbstractStAXParser(XMLStreamReader reader) {
        Checks.isNotNull((Object)reader, (String)"reader");
        this.reader = reader;
    }

    protected final Logger getLogger() {
        return this.logger;
    }

    protected void trace(String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message + ": " + StAXSupport.toString(this.reader));
        }
    }

    protected abstract R parse() throws XMLStreamException;

    protected final InvalidDataException error(String message) {
        this.logger.error(message);
        return new InvalidDataException(message);
    }

    protected final InvalidDataException unexpectedEvent() {
        return this.error("Unexpected event: " + StAXSupport.toString(this.reader));
    }

    protected int next() throws XMLStreamException {
        this.trace("next()    called on");
        return this.reader.next();
    }

    protected int nextTag() throws XMLStreamException {
        this.trace("nextTag() called on");
        int result = this.reader.nextTag();
        return result;
    }

    protected void ignoreElement() throws XMLStreamException {
        this.trace("ignoreElement()");
        int depth = 1;
        String name = this.reader.getLocalName();
        boolean go = true;
        block5: while (go) {
            switch (this.reader.getEventType()) {
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 12: {
                    this.next();
                    continue block5;
                }
                case 1: {
                    ++depth;
                    this.next();
                    continue block5;
                }
                case 2: {
                    if (--depth == 1) {
                        go = false;
                        continue block5;
                    }
                    this.next();
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        this.expectEndElement("ignoreElement()", name);
    }

    protected <C> void parseChildren(C context, String name, ContextElementParser<C> childParser) throws XMLStreamException {
        if (this.isStartElement(name)) {
            this.nextTag();
            while (this.reader.isStartElement()) {
                childParser.parseChild(context);
                this.nextTag();
            }
        } else {
            throw this.unexpectedEvent();
        }
        this.expectEndElement("parseChildren()", name);
    }

    protected void parseChildren(String name, ElementParser childParser) throws XMLStreamException {
        if (this.isStartElement(name)) {
            this.nextTag();
            while (this.reader.isStartElement()) {
                childParser.parseChild();
                this.nextTag();
            }
        } else {
            throw this.unexpectedEvent();
        }
        this.expectEndElement("parseChildren()", name);
    }

    protected void expect(String context, int eventType) {
        if (this.reader.getEventType() != eventType) {
            throw this.error("[" + context + "] Unexpected event: " + StAXSupport.toString(this.reader) + ", expected: " + StAXSupport.eventTypeToString(eventType));
        }
    }

    protected void expectStartElement(String context, String name) {
        this.expect(context, 1);
        if (!name.equals(this.reader.getLocalName())) {
            throw this.error("[" + context + "] Unexpected element name: " + this.reader.getLocalName() + ", expected: " + name);
        }
    }

    protected void expectStartElement(String context, String ... names) {
        this.expect(context, 1);
        for (String name : names) {
            if (name.equals(this.reader.getLocalName())) continue;
            return;
        }
        throw this.error("[" + context + "] Unexpected element name: " + this.reader.getLocalName() + ", expected: " + Arrays.toString(names));
    }

    protected void expectEndElement(String context, String name) {
        this.expect(context, 2);
        if (!name.equals(this.reader.getLocalName())) {
            throw this.error("[" + context + "] Unexpected element name: " + this.reader.getLocalName() + ", expected: " + name);
        }
    }

    protected void expectStartDocument(String context) {
        this.expect(context, 7);
    }

    protected void expectEndDocument(String context) {
        this.expect(context, 8);
    }

    protected boolean isStartElement(String name) {
        return this.reader.isStartElement() && name.equals(this.reader.getLocalName());
    }

    protected String getAttributeValue(String name, String def, FailureReaction missingReaction) {
        String value = this.reader.getAttributeValue(null, name);
        if (value == null) {
            if (missingReaction == FailureReaction.DEFAULT) {
                return def;
            }
            if (missingReaction == FailureReaction.WARN) {
                this.logger.warn("No attribute named '" + name + "'");
                return def;
            }
            throw new NotFoundException("No attribute named '" + name + "'");
        }
        return value;
    }

    protected String getAttributeValue(String name, String def) {
        return this.getAttributeValue(name, def, FailureReaction.DEFAULT);
    }

    protected boolean getAttributeAsBoolean(String name, boolean def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asBoolean((String)this.getAttributeValue(name, null), (boolean)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected boolean getAttributeAsBoolean(String name, boolean def) {
        return this.getAttributeAsBoolean(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Boolean getAttributeAsOptionalBoolean(String name, Boolean def, FailureReaction errorReaction) {
        return StringConversion.asOptionalBoolean((String)this.getAttributeValue(name, null), (Boolean)def, (FailureReaction)errorReaction);
    }

    protected Boolean getAttributeAsOptionalBoolean(String name, Boolean def) {
        return this.getAttributeAsOptionalBoolean(name, def, FailureReaction.FAIL);
    }

    protected long getAttributeAsLong(String name, long def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asLong((String)this.getAttributeValue(name, null), (long)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected long getAttributeAsLong(String name, long def) {
        return this.getAttributeAsLong(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Long getAttributeAsOptionalLong(String name, Long def, FailureReaction errorReaction) {
        return StringConversion.asOptionalLong((String)this.getAttributeValue(name, null), (Long)def, (FailureReaction)errorReaction);
    }

    protected Long getAttributeAsOptionalLong(String name, Long def) {
        return this.getAttributeAsOptionalLong(name, def, FailureReaction.FAIL);
    }

    protected int getAttributeAsInt(String name, int def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asInt((String)this.getAttributeValue(name, null), (int)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected int getAttributeAsInt(String name, int def) {
        return this.getAttributeAsInt(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Integer getAttributeAsOptionalInt(String name, Integer def, FailureReaction errorReaction) {
        return StringConversion.asOptionalInt((String)this.getAttributeValue(name, null), (Integer)def, (FailureReaction)errorReaction);
    }

    protected Integer getAttributeAsOptionalInt(String name, Integer def) {
        return this.getAttributeAsOptionalInt(name, def, FailureReaction.FAIL);
    }

    protected short getAttributeAsShort(String name, short def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asShort((String)this.getAttributeValue(name, null), (short)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected short getAttributeAsShort(String name, short def) {
        return this.getAttributeAsShort(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Short getAttributeAsOptionalShort(String name, Short def, FailureReaction errorReaction) {
        return StringConversion.asOptionalShort((String)this.getAttributeValue(name, null), (Short)def, (FailureReaction)errorReaction);
    }

    protected Short getAttributeAsOptionalShort(String name, Short def) {
        return this.getAttributeAsOptionalShort(name, def, FailureReaction.FAIL);
    }

    protected byte getAttributeAsByte(String name, byte def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asByte((String)this.getAttributeValue(name, null), (byte)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected byte getAttributeAsByte(String name, byte def) {
        return this.getAttributeAsByte(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Byte getAttributeAsOptionalByte(String name, Byte def, FailureReaction errorReaction) {
        return StringConversion.asOptionalByte((String)this.getAttributeValue(name, null), (Byte)def, (FailureReaction)errorReaction);
    }

    protected Byte getAttributeAsOptionalByte(String name, Byte def) {
        return this.getAttributeAsOptionalByte(name, def, FailureReaction.FAIL);
    }

    protected double getAttributeAsDouble(String name, double def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asDouble((String)this.getAttributeValue(name, null), (double)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected double getAttributeAsDouble(String name, double def) {
        return this.getAttributeAsDouble(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Double getAttributeAsOptionalDouble(String name, Double def, FailureReaction errorReaction) {
        return StringConversion.asOptionalDouble((String)this.getAttributeValue(name, null), (Double)def, (FailureReaction)errorReaction);
    }

    protected Double getAttributeAsOptionalDouble(String name, Double def) {
        return this.getAttributeAsOptionalDouble(name, def, FailureReaction.FAIL);
    }

    protected float getAttributeAsFloat(String name, float def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asFloat((String)this.getAttributeValue(name, null), (float)def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected float getAttributeAsFloat(String name, float def) {
        return this.getAttributeAsFloat(name, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Float getAttributeAsOptionalFloat(String name, Float def, FailureReaction errorReaction) {
        return StringConversion.asOptionalFloat((String)this.getAttributeValue(name, null), (Float)def, (FailureReaction)errorReaction);
    }

    protected Float getAttributeAsOptionalFloat(String name, Float def) {
        return this.getAttributeAsOptionalFloat(name, def, FailureReaction.FAIL);
    }

    protected Enum<?> getAttributeAsRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return StringConversion.asRawEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected Enum<?> getAttributeAsRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def) {
        return this.getAttributeAsRawEnum(name, enumClass, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected Enum<?> getAttributeAsOptionalRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def, FailureReaction errorReaction) {
        return StringConversion.asOptionalRawEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)errorReaction);
    }

    protected Enum<?> getAttributeAsOptionalRawEnum(String name, Class<? extends Enum<?>> enumClass, Enum<?> def) {
        return this.getAttributeAsOptionalRawEnum(name, enumClass, def, FailureReaction.FAIL);
    }

    protected <E extends Enum<E>> E getAttributeAsEnum(String name, Class<E> enumClass, E def, FailureReaction missingReaction, FailureReaction errorReaction) {
        return (E)StringConversion.asEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)missingReaction, (FailureReaction)errorReaction);
    }

    protected <E extends Enum<E>> E getAttributeAsEnum(String name, Class<E> enumClass, E def) {
        return this.getAttributeAsEnum(name, enumClass, def, FailureReaction.DEFAULT, FailureReaction.FAIL);
    }

    protected <E extends Enum<E>> E getAttributeAsOptionalEnum(String name, Class<E> enumClass, E def, FailureReaction errorReaction) {
        return (E)StringConversion.asOptionalEnum((String)this.getAttributeValue(name, null), enumClass, def, (FailureReaction)errorReaction);
    }

    protected <E extends Enum<E>> E getAttributeAsOptionalEnum(String name, Class<E> enumClass, E def) {
        return this.getAttributeAsOptionalEnum(name, enumClass, def, FailureReaction.FAIL);
    }

    @FunctionalInterface
    public static interface ElementParser {
        public void parseChild() throws XMLStreamException;
    }

    @FunctionalInterface
    public static interface ContextElementParser<C> {
        public void parseChild(C var1) throws XMLStreamException;
    }
}

