/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IntSet {
    private static final Logger LOGGER = LogManager.getLogger(IntSet.class);
    private final int[] values;

    public IntSet(int ... values) {
        if (values.length > 0) {
            int index;
            if (values.length % 2 != 0) {
                throw new IllegalArgumentException("values length is not even");
            }
            for (index = 1; index < values.length; ++index) {
                if (values[index] >= values[index - 1]) continue;
                throw new IllegalArgumentException("values are not sorted: " + Arrays.toString(values));
            }
            for (index = 2; index < values.length; ++index) {
                if (index % 2 != 0 || values[index] != values[index - 1] + 1) continue;
                LOGGER.warn("merge " + index + " with " + (index - 1) + " in " + Arrays.toString(values));
            }
        }
        this.values = (int[])values.clone();
    }

    public boolean contains(int value) {
        int index = Arrays.binarySearch(this.values, value);
        return index >= 0 || index % 2 == 0;
    }

    public int[] getValues() {
        return (int[])this.values.clone();
    }
}

