/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import javax.xml.stream.XMLStreamReader;

public final class StAXSupport {
    private StAXSupport() {
    }

    public static String eventTypeToString(int eventType) {
        switch (eventType) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return "???";
    }

    public static String toString(XMLStreamReader reader) {
        StringBuilder builder = new StringBuilder();
        builder.append(StAXSupport.eventTypeToString(reader.getEventType()));
        switch (reader.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                builder.append(" (");
                builder.append(reader.getLocalName());
                builder.append(")");
                break;
            }
        }
        return builder.toString();
    }
}

