/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.compress.CompressionUtils;
import cdc.util.compress.Compressor;
import cdc.util.io.NonCloseableOutputStream;
import cdc.util.lang.Checks;
import cdc.util.lang.IntMasks;
import cdc.util.lang.InvalidDataException;
import cdc.util.lang.InvalidStateException;
import cdc.util.strings.CaseConverter;
import cdc.util.strings.StringConversion;
import cdc.util.xml.XmlUtils;
import cdc.util.xml.XmlVersion;
import cdc.util.xml.XmlWriterContext;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlWriter
implements Flushable,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger(XmlWriter.class);
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    protected static final Pattern CDATA_END_PATTERN = Pattern.compile("]]>");
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    public static final String LF = "&#xA;";
    public static final String CR = "&#xD;";
    public static final String TAB = "&#x9;";
    public static final String GT = "&gt;";
    public static final String LT = "&lt;";
    public static final String QUOT = "&quot;";
    public static final String APOS = "&apos;";
    public static final String AMP = "&amp;";
    public static final String XMLNS = "xmlns";
    public static final String XMLNS_XSI = "xmlns:xsi";
    public static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    protected XmlVersion version = null;
    private int features = 0;
    protected boolean dontValidateNames = false;
    protected boolean dontValidateChars = false;
    private String attributeDelimiter = "\"";
    private String eol = System.lineSeparator();
    private int level = 0;
    private String indent = "  ";
    private XmlWriterContext context = new XmlWriterContext();
    private final StringBuilder buffer = new StringBuilder();
    private final Writer out;
    private final String encoding;
    private CaseConverter converter = new CaseConverter();
    private boolean needsEOL = false;

    private XmlWriter(OutputStream os, String encoding, boolean wrap, Compressor compressor) throws IOException {
        Checks.isNotNull((Object)encoding, (String)"encoding");
        Checks.isNotNull((Object)compressor, (String)"compressor");
        this.encoding = encoding;
        this.out = wrap ? new BufferedWriter(new OutputStreamWriter(CompressionUtils.adapt((OutputStream)new NonCloseableOutputStream(os), (Compressor)compressor), encoding)) : new BufferedWriter(new OutputStreamWriter(CompressionUtils.adapt((OutputStream)os, (Compressor)compressor), encoding));
    }

    public XmlWriter(Writer writer, String encoding) {
        this.out = writer;
        this.encoding = encoding;
    }

    public XmlWriter(Writer writer) {
        this(writer, StandardCharsets.UTF_8.name());
    }

    public XmlWriter() throws IOException {
        this(new BufferedOutputStream((OutputStream)NonCloseableOutputStream.NON_CLOSABLE_SYSTEM_OUT), StandardCharsets.UTF_8.name(), false, Compressor.NONE);
    }

    public XmlWriter(PrintStream out) throws IOException {
        this(new BufferedOutputStream((OutputStream)new NonCloseableOutputStream((OutputStream)out)), StandardCharsets.UTF_8.name(), false, Compressor.NONE);
    }

    public XmlWriter(OutputStream os, String encoding) throws IOException {
        this(os, encoding, true, Compressor.NONE);
    }

    public XmlWriter(OutputStream os) throws IOException {
        this(os, StandardCharsets.UTF_8.name());
    }

    public XmlWriter(String filename, String encoding, Compressor compressor) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(filename)), encoding, false, compressor);
    }

    public XmlWriter(String filename, String encoding) throws IOException {
        this(filename, encoding, Compressor.NONE);
    }

    public XmlWriter(String filename, Compressor compressor) throws IOException {
        this(filename, StandardCharsets.UTF_8.name(), compressor);
    }

    public XmlWriter(String filename) throws IOException {
        this(filename, StandardCharsets.UTF_8.name(), Compressor.NONE);
    }

    public XmlWriter(File file, String encoding, Compressor compressor) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)), encoding, false, compressor);
    }

    public XmlWriter(File file, String encoding) throws IOException {
        this(file, encoding, Compressor.NONE);
    }

    public XmlWriter(File file, Compressor compressor) throws IOException {
        this(file, StandardCharsets.UTF_8.name(), compressor);
    }

    public XmlWriter(File file) throws IOException {
        this(file, StandardCharsets.UTF_8.name(), Compressor.NONE);
    }

    private void stateError(String message) {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOGGER.catching((Throwable)e);
        }
        throw new InvalidStateException("Invalid state: " + (Object)((Object)this.context.getType()) + ", when calling: " + message);
    }

    protected static void dataError(String message) {
        throw new InvalidDataException("Invalid data: " + message);
    }

    private void writeEscapedAttribute(String s) throws IOException {
        if (s != null) {
            int codePoint;
            int length = s.length();
            block10: for (int index = 0; index < length; index += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(index);
                switch (codePoint) {
                    case 62: {
                        if (this.isEnabled(Feature.ALWAYS_ENTITIZE_ATTRIBUTES)) {
                            this.out.append(GT);
                            continue block10;
                        }
                        this.out.write(codePoint);
                        continue block10;
                    }
                    case 60: {
                        this.out.append(LT);
                        continue block10;
                    }
                    case 38: {
                        this.out.append(AMP);
                        continue block10;
                    }
                    case 39: {
                        if (this.attributeDelimiter == SINGLE_QUOTE || this.isEnabled(Feature.ALWAYS_ENTITIZE_ATTRIBUTES)) {
                            this.out.append(APOS);
                            continue block10;
                        }
                        this.out.write(codePoint);
                        continue block10;
                    }
                    case 34: {
                        if (this.attributeDelimiter == DOUBLE_QUOTE || this.isEnabled(Feature.ALWAYS_ENTITIZE_ATTRIBUTES)) {
                            this.out.append(QUOT);
                            continue block10;
                        }
                        this.out.write(codePoint);
                        continue block10;
                    }
                    case 13: {
                        if (index + 1 < length && s.charAt(index + 1) == '\n') {
                            ++index;
                            if (this.isEnabled(Feature.USE_XML_EOL)) {
                                this.out.append(LF);
                                continue block10;
                            }
                            this.out.append(CR);
                            this.out.append(LF);
                            continue block10;
                        }
                        if (this.isEnabled(Feature.USE_XML_EOL)) {
                            this.out.append(LF);
                            continue block10;
                        }
                        this.out.append(CR);
                        continue block10;
                    }
                    case 10: {
                        this.out.append(LF);
                        continue block10;
                    }
                    case 9: {
                        this.out.append(TAB);
                        continue block10;
                    }
                    default: {
                        if (!this.dontValidateChars && !XmlUtils.isXmlChar(codePoint, this.version)) {
                            XmlWriter.dataError("Invalid xml charater: '" + XmlUtils.codePointToString(codePoint) + SINGLE_QUOTE);
                        }
                        this.out.write(codePoint);
                    }
                }
            }
        }
    }

    private void writeEscaped(String s, EscapeContext context) throws IOException {
        if (s != null) {
            int codePoint;
            String str = context.validateNonNull(s, this);
            int length = str.length();
            block9: for (int index = 0; index < length; index += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(index);
                switch (codePoint) {
                    case 62: {
                        context.checkSupportsEntitiesCandidates();
                        if (!context.needsEntities()) continue block9;
                        this.out.append(GT);
                        continue block9;
                    }
                    case 60: {
                        context.checkSupportsEntitiesCandidates();
                        if (!context.needsEntities()) continue block9;
                        this.out.append(LT);
                        continue block9;
                    }
                    case 38: {
                        context.checkSupportsEntitiesCandidates();
                        if (!context.needsEntities()) continue block9;
                        this.out.append(AMP);
                        continue block9;
                    }
                    case 39: {
                        context.checkSupportsEntitiesCandidates();
                        if (!context.needsEntities()) continue block9;
                        this.out.append(APOS);
                        continue block9;
                    }
                    case 34: {
                        context.checkSupportsEntitiesCandidates();
                        if (!context.needsEntities()) continue block9;
                        this.out.append(QUOT);
                        continue block9;
                    }
                    case 13: {
                        context.checkSupportsEOL();
                        if (index + 1 < length && str.charAt(index + 1) == '\n') {
                            ++index;
                        }
                        this.out.append(this.eol);
                        continue block9;
                    }
                    case 10: {
                        context.checkSupportsEOL();
                        this.out.append(this.eol);
                        continue block9;
                    }
                    default: {
                        this.out.write(codePoint);
                    }
                }
            }
        }
    }

    private void write(String s) throws IOException {
        this.flushln();
        this.out.append(s);
    }

    private void flushln() throws IOException {
        if (this.needsEOL) {
            this.out.append(this.eol);
            this.needsEOL = false;
        }
    }

    private void writeln() throws IOException {
        this.flushln();
        if (this.isEnabled(Feature.PRETTY_PRINT)) {
            this.needsEOL = true;
        }
    }

    private void indent() throws IOException {
        if (this.isEnabled(Feature.PRETTY_PRINT)) {
            for (int i = 0; i < this.level; ++i) {
                this.write(this.indent);
            }
        }
    }

    public final XmlWriter setEnabled(Feature feature, boolean enabled) {
        this.features = IntMasks.setEnabled((int)this.features, (Enum)feature, (boolean)enabled);
        switch (feature) {
            case USE_SINGLE_QUOTE: {
                if (this.isEnabled(Feature.USE_SINGLE_QUOTE)) {
                    this.attributeDelimiter = SINGLE_QUOTE;
                    break;
                }
                this.attributeDelimiter = DOUBLE_QUOTE;
                break;
            }
            case USE_XML_EOL: {
                if (this.isEnabled(Feature.USE_XML_EOL)) {
                    this.eol = "\n";
                    break;
                }
                this.eol = System.lineSeparator();
                break;
            }
            case DONT_VALIDATE_CHARS: {
                this.dontValidateChars = enabled;
                break;
            }
            case DONT_VALIDATE_NAMES: {
                this.dontValidateNames = enabled;
                break;
            }
        }
        return this;
    }

    public final XmlWriter setEnabled(Feature ... features) {
        if (features != null) {
            for (Feature feature : features) {
                this.setEnabled(feature, true);
            }
        }
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return IntMasks.isEnabled((int)this.features, (Enum)feature);
    }

    public final XmlWriter setIndentString(String s) {
        this.indent = s == null ? "" : s;
        return this;
    }

    public final String getIndentString() {
        return this.indent;
    }

    public final void setTabSize(int tabSize) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < tabSize; ++index) {
            builder.append(" ");
        }
        this.setIndentString(builder.toString());
    }

    public final void setEndOfLine(String eol) {
        this.eol = eol;
    }

    public final String getEndOfLine() {
        return this.eol;
    }

    public final CaseConverter getConverter() {
        return this.converter;
    }

    public final void setCaseConverter(CaseConverter converter) {
        Checks.isNotNull((Object)converter, (String)"converter");
        this.converter = converter;
    }

    public final void beginDocument(XmlVersion version) throws IOException {
        if (this.context.getType() == XmlWriterContext.Type.IN_OPEN_STREAM) {
            this.context = this.context.pushContext(XmlWriterContext.Type.IN_OPEN_DOC);
            this.version = version;
        } else {
            this.stateError("beginDocument()");
        }
        this.write("<?xml version=\"");
        this.write(version.getLabel());
        this.write(DOUBLE_QUOTE);
        this.write(" encoding=\"");
        this.write(this.encoding);
        this.write(DOUBLE_QUOTE);
        this.write("?>");
        this.writeln();
    }

    public final void beginDocument() throws IOException {
        this.beginDocument(XmlVersion.XML_1_0);
    }

    public final void beginProcessingInstruction(String target) throws IOException {
        switch (this.context.getType()) {
            case IN_OPEN_DOC: 
            case IN_CLOSED_DOC: 
            case IN_MIXED_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_PI);
                break;
            }
            case IN_SIMPLE_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_PI);
                this.indent();
                break;
            }
            case IN_TAG: {
                this.write(">");
                this.context.setType(XmlWriterContext.Type.IN_SIMPLE_CONTENT);
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_PI);
                this.writeln();
                this.indent();
                break;
            }
            default: {
                this.stateError("beginProcessingInstruction()");
            }
        }
        this.write("<?");
        this.writeEscaped(target, EscapeContext.PI_TARGET);
    }

    public final void addProcessingInstructionContent(String content) throws IOException {
        if (this.context.getType() != XmlWriterContext.Type.IN_PI) {
            this.stateError("addProcessingInstructionContent()");
        }
        this.writeEscaped(content, EscapeContext.PI_CONTENT);
    }

    public final void endProcessingInstruction() throws IOException {
        if (this.context.getType() == XmlWriterContext.Type.IN_PI) {
            this.context = this.context.popContext();
        } else {
            this.stateError("endProcessingInstruction()");
        }
        this.write("?>");
        if (this.context.getType() != XmlWriterContext.Type.IN_MIXED_CONTENT) {
            this.writeln();
        }
    }

    public final void addProcessingInstruction(String target, String content) throws IOException {
        this.beginProcessingInstruction(target);
        this.write(" ");
        this.addProcessingInstructionContent(content);
        this.endProcessingInstruction();
    }

    public final void addStyleSheet(String xsl) throws IOException {
        this.beginProcessingInstruction("xml-stylesheet");
        this.addAttribute("type", "text/xsl");
        this.addAttribute("href", xsl);
        this.endProcessingInstruction();
    }

    public final void beginComment() throws IOException {
        switch (this.context.getType()) {
            case IN_OPEN_DOC: 
            case IN_CLOSED_DOC: 
            case IN_MIXED_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_COMMENT);
                break;
            }
            case IN_SIMPLE_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_COMMENT);
                this.indent();
                break;
            }
            case IN_TAG: {
                this.write(">");
                this.context.setType(XmlWriterContext.Type.IN_SIMPLE_CONTENT);
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_COMMENT);
                this.writeln();
                this.indent();
                break;
            }
            case IN_OPEN_STREAM: {
                if (this.isEnabled(Feature.ALLOW_PARTIAL_XML)) {
                    this.context = this.context.pushContext(XmlWriterContext.Type.IN_COMMENT);
                    break;
                }
                this.stateError("beginComment()");
                break;
            }
            default: {
                this.stateError("beginComment()");
            }
        }
        this.write("<!--");
    }

    public final void addCommentContent(String content) {
        if (this.context.getType() == XmlWriterContext.Type.IN_COMMENT) {
            this.buffer.append(content);
        } else {
            this.stateError("addCommentContent()");
        }
    }

    public final void endComment() throws IOException {
        if (this.context.getType() == XmlWriterContext.Type.IN_COMMENT) {
            this.writeEscaped(this.buffer.toString(), EscapeContext.COMMENT);
            this.buffer.setLength(0);
            this.context = this.context.popContext();
        } else {
            this.stateError("endComment()");
        }
        this.write("-->");
        if (this.context.getType() != XmlWriterContext.Type.IN_MIXED_CONTENT) {
            this.writeln();
        }
    }

    public final void addComment(String content) throws IOException {
        this.beginComment();
        this.addCommentContent(content);
        this.endComment();
    }

    public final void beginCData() throws IOException {
        switch (this.context.getType()) {
            case IN_SIMPLE_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_CDATA);
                this.indent();
                break;
            }
            case IN_MIXED_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_CDATA);
                break;
            }
            case IN_TAG: {
                this.write(">");
                this.writeln();
                this.indent();
                this.context.setType(XmlWriterContext.Type.IN_SIMPLE_CONTENT);
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_CDATA);
                break;
            }
            default: {
                this.stateError("beginCData()");
            }
        }
        this.write(CDATA_START);
    }

    public final void addCDataContent(String content) {
        if (this.context.getType() == XmlWriterContext.Type.IN_CDATA) {
            if (content != null) {
                this.buffer.append(content);
            }
        } else {
            this.stateError("addCDataContent()");
        }
    }

    public final void endCData() throws IOException {
        if (this.context.getType() == XmlWriterContext.Type.IN_CDATA) {
            this.writeEscaped(this.buffer.toString(), EscapeContext.CDATA);
            this.buffer.setLength(0);
            this.context = this.context.popContext();
        } else {
            this.stateError("endCData()");
        }
        this.write(CDATA_END);
        if (this.context.getType() != XmlWriterContext.Type.IN_MIXED_CONTENT) {
            this.writeln();
        }
    }

    public final void addCData(String content) throws IOException {
        this.beginCData();
        this.addCDataContent(content);
        this.endCData();
    }

    public final void beginElement(String name) throws IOException {
        String ename = this.isEnabled(Feature.USE_CONVERTER) ? this.converter.splitAndConvert(name) : name;
        switch (this.context.getType()) {
            case IN_OPEN_DOC: 
            case IN_SIMPLE_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_TAG);
                this.context.setName(ename);
                this.indent();
                break;
            }
            case IN_MIXED_CONTENT: {
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_TAG);
                this.context.setName(ename);
                break;
            }
            case IN_TAG: {
                this.context.setType(XmlWriterContext.Type.IN_SIMPLE_CONTENT);
                this.context = this.context.pushContext(XmlWriterContext.Type.IN_TAG);
                this.context.setName(ename);
                this.write(">");
                this.writeln();
                this.indent();
                break;
            }
            case IN_OPEN_STREAM: {
                if (this.isEnabled(Feature.ALLOW_PARTIAL_XML)) {
                    this.context = this.context.pushContext(XmlWriterContext.Type.IN_TAG);
                    this.context.setName(ename);
                    break;
                }
                this.stateError("beginElement()");
                break;
            }
            default: {
                this.stateError("beginElement()");
            }
        }
        this.write("<");
        this.writeEscaped(ename, EscapeContext.NAME);
        ++this.level;
    }

    public final void addAttribute(String name, Object value) throws IOException {
        if (value == null) {
            this.addAttribute(name, "");
        } else {
            this.addAttribute(name, value.toString());
        }
    }

    public final void addAttribute(String name, String value) throws IOException {
        this.addAttribute(name, value, true);
    }

    public final void addAttribute(String name, char value) throws IOException {
        this.addAttribute(name, Character.toString(value));
    }

    public final void addAttribute(String name, boolean value) throws IOException {
        this.addAttribute(name, StringConversion.asString((boolean)value));
    }

    public final void addAttribute(String name, long value) throws IOException {
        this.addAttribute(name, StringConversion.asString((long)value));
    }

    public final void addAttribute(String name, int value) throws IOException {
        this.addAttribute(name, StringConversion.asString((int)value));
    }

    public final void addAttribute(String name, short value) throws IOException {
        this.addAttribute(name, StringConversion.asString((short)value));
    }

    public final void addAttribute(String name, byte value) throws IOException {
        this.addAttribute(name, StringConversion.asString((byte)value));
    }

    public final void addAttribute(String name, double value) throws IOException {
        this.addAttribute(name, StringConversion.asString((double)value));
    }

    public final void addAttribute(String name, float value) throws IOException {
        this.addAttribute(name, StringConversion.asString((float)value));
    }

    private final void addAttribute(String name, String value, boolean allowConverter) throws IOException {
        String ename = allowConverter && this.isEnabled(Feature.USE_CONVERTER) && this.context.getType() != XmlWriterContext.Type.IN_PI ? this.converter.splitAndConvert(name) : name;
        switch (this.context.getType()) {
            case IN_TAG: 
            case IN_PI: {
                break;
            }
            default: {
                this.stateError("addAttribute()");
            }
        }
        this.write(" ");
        this.writeEscaped(ename, EscapeContext.NAME);
        this.write("=");
        this.write(this.attributeDelimiter);
        this.writeEscapedAttribute(value == null ? "" : value);
        this.write(this.attributeDelimiter);
    }

    public final void addNamespace(String prefix, String uri) throws IOException {
        this.addAttribute("xmlns:" + prefix, uri, false);
    }

    public final void addDefaultNamespace(String uri) throws IOException {
        this.addAttribute(XMLNS, uri);
    }

    public final void addElementContent(String content) throws IOException {
        switch (this.context.getType()) {
            case IN_TAG: {
                this.context.setType(XmlWriterContext.Type.IN_MIXED_CONTENT);
                this.write(">");
                break;
            }
            case IN_SIMPLE_CONTENT: {
                this.context.setType(XmlWriterContext.Type.IN_MIXED_CONTENT);
                break;
            }
            case IN_CLOSED_DOC: 
            case IN_MIXED_CONTENT: {
                break;
            }
            default: {
                this.stateError("addElementContent()");
            }
        }
        this.writeEscaped(content, EscapeContext.ELEMENT_CONTENT);
    }

    public final void endElement() throws IOException {
        --this.level;
        switch (this.context.getType()) {
            case IN_TAG: {
                this.context = this.context.popContext();
                this.write("/>");
                this.writeln();
                break;
            }
            case IN_SIMPLE_CONTENT: {
                this.indent();
                this.write("</");
                this.writeEscaped(this.context.getName(), EscapeContext.NAME);
                this.write(">");
                this.writeln();
                this.context = this.context.popContext();
                break;
            }
            case IN_MIXED_CONTENT: {
                this.write("</");
                this.writeEscaped(this.context.getName(), EscapeContext.NAME);
                this.write(">");
                this.context = this.context.popContext();
                if (this.context.getType() != XmlWriterContext.Type.IN_SIMPLE_CONTENT) break;
                this.writeln();
                break;
            }
            default: {
                this.stateError("endElement()");
            }
        }
        if (this.context.getType() == XmlWriterContext.Type.IN_OPEN_DOC) {
            this.context.setType(XmlWriterContext.Type.IN_CLOSED_DOC);
        }
    }

    public final void addElement(String name, String content) throws IOException {
        this.beginElement(name);
        this.addElementContent(content);
        this.endElement();
    }

    public final void addElementIfNonEmpty(String name, String content) throws IOException {
        if (content != null && content.length() > 0) {
            this.addElement(name, content);
        }
    }

    public final void endDocument() throws IOException {
        switch (this.context.getType()) {
            case IN_OPEN_DOC: 
            case IN_CLOSED_DOC: {
                this.context = this.context.popContext();
                this.context.setType(XmlWriterContext.Type.IN_CLOSED_STREAM);
                if (!this.isEnabled(Feature.APPEND_FINAL_EOL)) break;
                if (!this.needsEOL) {
                    this.writeln();
                }
                this.flushln();
                break;
            }
            default: {
                this.stateError("endDocument()");
            }
        }
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        switch (this.context.getType()) {
            case IN_CLOSED_STREAM: {
                break;
            }
            case IN_OPEN_STREAM: {
                if (this.isEnabled(Feature.ALLOW_PARTIAL_XML)) {
                    this.context.setType(XmlWriterContext.Type.IN_CLOSED_STREAM);
                    if (!this.isEnabled(Feature.APPEND_FINAL_EOL)) break;
                    if (!this.needsEOL) {
                        this.writeln();
                    }
                    this.flushln();
                    break;
                }
                this.stateError("close()");
                break;
            }
            default: {
                this.stateError("close()");
            }
        }
        this.out.close();
    }

    public void reset() {
        this.context = this.context.popAll();
        this.context.setType(XmlWriterContext.Type.IN_OPEN_STREAM);
    }

    private static enum EscapeContext {
        CDATA,
        COMMENT,
        ELEMENT_CONTENT,
        NAME,
        PI_CONTENT,
        PI_TARGET;


        public boolean supportsEOL() {
            return this == CDATA || this == COMMENT || this == ELEMENT_CONTENT;
        }

        public void checkSupportsEOL() {
            if (!this.supportsEOL()) {
                XmlWriter.dataError("Unexpected eol");
            }
        }

        public boolean supportsEntitiesCandidates() {
            return this == CDATA || this == COMMENT || this == ELEMENT_CONTENT || this == PI_CONTENT;
        }

        public void checkSupportsEntitiesCandidates() {
            if (!this.supportsEntitiesCandidates()) {
                XmlWriter.dataError("Unexpected entity character");
            }
        }

        public boolean needsEntities() {
            return this == ELEMENT_CONTENT;
        }

        public String validateNonNull(String s, XmlWriter caller) {
            if (this == NAME) {
                if (!caller.dontValidateNames && !XmlUtils.isValidName(s)) {
                    XmlWriter.dataError("Invalid name: '" + s + XmlWriter.SINGLE_QUOTE);
                }
                return s;
            }
            if (!caller.dontValidateChars && !XmlUtils.isValidXml(s, caller.version)) {
                XmlWriter.dataError("Invalid chars: '" + s + XmlWriter.SINGLE_QUOTE);
            }
            switch (this) {
                case CDATA: {
                    Matcher m = CDATA_END_PATTERN.matcher(s);
                    if (m.find()) {
                        return m.replaceAll("]]]]><![CDATA[>");
                    }
                    return s;
                }
                case COMMENT: {
                    if (s.contains("--")) {
                        XmlWriter.dataError("Unexpected '--' in comment");
                    }
                    return s;
                }
            }
            return s;
        }
    }

    public static enum Feature {
        PRETTY_PRINT,
        USE_XML_EOL,
        APPEND_FINAL_EOL,
        USE_SINGLE_QUOTE,
        ALWAYS_ENTITIZE_ATTRIBUTES,
        USE_CONVERTER,
        ALLOW_PARTIAL_XML,
        DONT_VALIDATE_NAMES,
        DONT_VALIDATE_CHARS;

    }
}

