/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class XmlWriterContext {
    protected static final Logger LOGGER = LogManager.getLogger(XmlWriterContext.class);
    private Type type;
    private String name;
    private final XmlWriterContext parent;
    private XmlWriterContext child = null;

    private XmlWriterContext(Type type, XmlWriterContext parent) {
        this.type = type;
        this.parent = parent;
        if (parent != null) {
            parent.child = this;
        }
    }

    XmlWriterContext() {
        this(Type.IN_OPEN_STREAM, null);
    }

    XmlWriterContext pushContext(Type type) {
        LOGGER.trace("pushContext(" + (Object)((Object)type) + ")");
        if (this.child == null) {
            XmlWriterContext result = new XmlWriterContext(type, this);
            return result;
        }
        this.child.setType(type);
        return this.child;
    }

    final XmlWriterContext popContext() {
        LOGGER.trace("popContext()");
        this.type = null;
        this.name = null;
        return this.parent;
    }

    final XmlWriterContext popAll() {
        XmlWriterContext index = this;
        while (index.parent != null) {
            index = index.popContext();
        }
        return index;
    }

    final Type getType() {
        return this.type;
    }

    final void setType(Type type) {
        LOGGER.trace("setType(" + (Object)((Object)type) + ")");
        this.type = type;
    }

    final void setName(String name) {
        LOGGER.trace("setName(" + name + ")");
        this.name = name;
    }

    final String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type);
        if (this.name != null) {
            builder.append(" ").append(this.name);
        }
        return builder.toString();
    }

    private void print() {
        if (this.parent != null) {
            this.parent.print();
        }
        LOGGER.trace("   " + this.toString());
    }

    public void print(String message) {
        LOGGER.trace("---------------------");
        LOGGER.trace(message);
        this.print();
    }

    public static enum Type {
        IN_OPEN_STREAM,
        IN_OPEN_DOC,
        IN_TAG,
        IN_PI,
        IN_SIMPLE_CONTENT,
        IN_MIXED_CONTENT,
        IN_COMMENT,
        IN_CDATA,
        IN_CLOSED_DOC,
        IN_CLOSED_STREAM;

    }
}

