/*
 * Decompiled with CFR 0.152.
 */
package cdc.test.util.xml;

import cdc.util.lang.InvalidDataException;
import cdc.util.xml.XmlWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlWriterTest {
    private static final Logger LOGGER = LogManager.getLogger(XmlWriterTest.class);
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String EOL = "";
    private static final String INDENT = "";
    private static final String TARGET = "target";
    private static final boolean ENABLE_FINAL_EOL = true;
    private static final String FINAL_EOL = "";
    private static final String LINE = "=============================================================";

    private static void init(XmlWriter xmlw) {
        xmlw.setEndOfLine("");
        xmlw.setIndentString("");
        xmlw.setEnabled(XmlWriter.Feature.PRETTY_PRINT, false);
        xmlw.setEnabled(XmlWriter.Feature.APPEND_FINAL_EOL, true);
    }

    private static void check(String expected, Writer writer) {
        if (expected.equals(writer.toString())) {
            LOGGER.debug("expected and obtained:\n=============================================================\n" + expected + "\n");
        } else {
            LOGGER.error("expect:\n=============================================================\n" + expected + "\n");
            LOGGER.error("result:\n=============================================================\n" + writer.toString() + "\n");
        }
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    @Test
    public void testIndentDocument() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.endDocument();
        xmlw.close();
        String expected = XML;
        XmlWriterTest.check(XML, writer);
    }

    @Test
    public void testIndentDocumentComment1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addComment("XXX");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX-->";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX-->", writer);
    }

    @Test
    public void testIndentDocumentComment2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addComment("XXX");
        xmlw.addComment("XXX");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><!--XXX-->";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><!--XXX-->", writer);
    }

    @Test
    public void testIndentSimpleContent1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>", writer);
    }

    @Test
    public void testIndentSimpleContent2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.beginElement("child");
        xmlw.beginElement("sub");
        xmlw.addAttribute("a1", "v");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/><child><sub a1=\"v\"/></child></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><child/><child><sub a1=\"v\"/></child></root>", writer);
    }

    @Test
    public void testIndentSimpleContentComment1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addComment("XXX");
        xmlw.beginElement("root");
        xmlw.addComment("XXX");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--></root>", writer);
    }

    @Test
    public void testIndentSimpleContentComment2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addComment("XXX");
        xmlw.beginElement("root");
        xmlw.addComment("XXX");
        xmlw.endElement();
        xmlw.addComment("XXX");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--></root><!--XXX-->";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--></root><!--XXX-->", writer);
    }

    @Test
    public void testIndentSimpleContentComment3() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addComment("XXX");
        xmlw.beginElement("root");
        xmlw.addComment("XXX");
        xmlw.beginElement("child");
        xmlw.addComment("XXX");
        xmlw.endElement();
        xmlw.addComment("XXX");
        xmlw.endElement();
        xmlw.addComment("XXX");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--><child><!--XXX--></child><!--XXX--></root><!--XXX-->";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!--XXX--><root><!--XXX--><child><!--XXX--></child><!--XXX--></root><!--XXX-->", writer);
    }

    @Test
    public void testIndentMixedContent1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>CCC</root>", writer);
    }

    @Test
    public void testIndentMixedContent2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addElementContent("CCC");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>CCC<b>CCC</b></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>CCC<b>CCC</b></root>", writer);
    }

    @Test
    public void testIndentMixedContent3() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b></root>", writer);
    }

    @Test
    public void testIndentMixedContent4() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addElementContent("");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b>CCC</root>", writer);
    }

    @Test
    public void testIndentMixedContentComment1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addElementContent("");
        xmlw.addComment("XXX");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--XXX--><b>CCC</b>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--XXX--><b>CCC</b>CCC</root>", writer);
    }

    @Test
    public void testIndentMixedContentComment2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><b>CCC</b>CCC</root>", writer);
    }

    @Test
    public void testIndentMixedContentComment3() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addComment("XXX");
        xmlw.beginElement("b");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--XXX--><b>CCC</b>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--XXX--><b>CCC</b>CCC</root>", writer);
    }

    @Test
    public void testIndentCData1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addCData("DDD");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]></root>", writer);
    }

    @Test
    public void testIndentCData2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addCData("DDD");
        xmlw.addCData("DDD");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><![CDATA[DDD]]></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><![CDATA[DDD]]></root>", writer);
    }

    @Test
    public void testIndentCDataComment() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addComment("CCC");
        xmlw.addCData("DDD");
        xmlw.addComment("CCC");
        xmlw.addCData("DDD");
        xmlw.addComment("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--CCC--><![CDATA[DDD]]><!--CCC--><![CDATA[DDD]]><!--CCC--></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--CCC--><![CDATA[DDD]]><!--CCC--><![CDATA[DDD]]><!--CCC--></root>", writer);
    }

    @Test
    public void testIndentCDataSimpleContent1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addCData("DDD");
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><child/></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><child/></root>", writer);
    }

    @Test
    public void testIndentCDataSimpleContent2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addCData("DDD");
        xmlw.beginElement("child");
        xmlw.addCData("DDD");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><child><![CDATA[DDD]]></child></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]><child><![CDATA[DDD]]></child></root>", writer);
    }

    @Test
    public void testIndentCDataSimpleContentComment() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addComment("CCC");
        xmlw.addCData("DDD");
        xmlw.beginElement("child");
        xmlw.addCData("DDD");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--CCC--><![CDATA[DDD]]><child><![CDATA[DDD]]></child></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><!--CCC--><![CDATA[DDD]]><child><![CDATA[DDD]]></child></root>", writer);
    }

    @Test
    public void testIndentCDataMixedContent1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addCData("DDD");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]>CCC</root>", writer);
    }

    @Test
    public void testIndentCDataMixedContent2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.beginElement("root");
        xmlw.addElementContent("");
        xmlw.addCData("DDD");
        xmlw.addElementContent("CCC");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]>CCC</root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><![CDATA[DDD]]>CCC</root>", writer);
    }

    @Test
    public void testIndentProcessingInstruction1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addProcessingInstruction(TARGET, "PPP");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?>", writer);
    }

    @Test
    public void testIndentProcessingInstruction2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addProcessingInstruction(TARGET, "PPP");
        xmlw.addProcessingInstruction(TARGET, "PPP");
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?><?target PPP?>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?><?target PPP?>", writer);
    }

    @Test
    public void testIndentProcessingInstruction3() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.beginDocument();
        xmlw.addProcessingInstruction(TARGET, "PPP");
        xmlw.beginElement("root");
        xmlw.addProcessingInstruction(TARGET, "PPP");
        xmlw.endElement();
        xmlw.endDocument();
        xmlw.close();
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?><root><?target PPP?></root>";
        XmlWriterTest.check("<?xml version=\"1.0\" encoding=\"UTF-8\"?><?target PPP?><root><?target PPP?></root>", writer);
    }

    @Test
    public void testPartialComment() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginComment();
        xmlw.addCommentContent("comment");
        xmlw.endComment();
        xmlw.close();
        String expected = "<!--comment-->";
        XmlWriterTest.check("<!--comment-->", writer);
    }

    @Test
    public void testPartialElement() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginElement("root");
        xmlw.addAttribute("id", "value");
        xmlw.endElement();
        xmlw.close();
        String expected = "<root id=\"value\"/>";
        XmlWriterTest.check("<root id=\"value\"/>", writer);
    }

    @Test
    public void testPartial1() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginElement("root");
        xmlw.addAttribute("id", "value");
        xmlw.addComment("comment");
        xmlw.endElement();
        xmlw.close();
        String expected = "<root id=\"value\"><!--comment--></root>";
        XmlWriterTest.check("<root id=\"value\"><!--comment--></root>", writer);
    }

    @Test
    public void testPartial2() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginElement("root");
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.close();
        String expected = "<root><child/><child/></root>";
        XmlWriterTest.check("<root><child/><child/></root>", writer);
    }

    @Test
    public void testPartial3() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.addComment("comment");
        xmlw.beginElement("root");
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.addComment("comment");
        xmlw.beginElement("child");
        xmlw.endElement();
        xmlw.endElement();
        xmlw.addComment("comment");
        xmlw.close();
        String expected = "<!--comment--><root><child/><!--comment--><child/></root><!--comment-->";
        XmlWriterTest.check("<!--comment--><root><child/><!--comment--><child/></root><!--comment-->", writer);
    }

    @Test
    public void testAttributeEscapingQuoteEntitizeAlways() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALWAYS_ENTITIZE_ATTRIBUTES});
        xmlw.beginElement("a");
        xmlw.addAttribute("a", "<>'\"&\t\n");
        xmlw.endElement();
        xmlw.close();
        String expected = "<a a=\"&lt;&gt;&apos;&quot;&amp;&#x9;&#xA;\"/>";
        XmlWriterTest.check("<a a=\"&lt;&gt;&apos;&quot;&amp;&#x9;&#xA;\"/>", writer);
    }

    @Test
    public void testAttributeEscapingQuoteEntitizeMin() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginElement("a");
        xmlw.addAttribute("a", "<>'\"&\t\n");
        xmlw.endElement();
        xmlw.close();
        String expected = "<a a=\"&lt;>'&quot;&amp;&#x9;&#xA;\"/>";
        XmlWriterTest.check("<a a=\"&lt;>'&quot;&amp;&#x9;&#xA;\"/>", writer);
    }

    @Test
    public void testAttributeEscapingAposEntitizeAlways() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALWAYS_ENTITIZE_ATTRIBUTES});
        xmlw.beginElement("a");
        xmlw.addAttribute("a", "<>'\"&\t\n");
        xmlw.endElement();
        xmlw.close();
        String expected = "<a a='&lt;&gt;&apos;&quot;&amp;&#x9;&#xA;'/>";
        XmlWriterTest.check("<a a='&lt;&gt;&apos;&quot;&amp;&#x9;&#xA;'/>", writer);
    }

    @Test
    public void testAttributeEscapingAposEntitizeMin() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.USE_SINGLE_QUOTE});
        xmlw.beginElement("a");
        xmlw.addAttribute("a", "<>'\"&\t\n");
        xmlw.endElement();
        xmlw.close();
        String expected = "<a a='&lt;>&apos;\"&amp;&#x9;&#xA;'/>";
        XmlWriterTest.check("<a a='&lt;>&apos;\"&amp;&#x9;&#xA;'/>", writer);
    }

    @Test
    public void testCDATAEscaping() throws IOException {
        StringWriter writer = new StringWriter();
        XmlWriter xmlw = new XmlWriter((Writer)writer);
        XmlWriterTest.init(xmlw);
        xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
        xmlw.beginElement("a");
        xmlw.addCData("<>'\"&abcd");
        xmlw.endElement();
        xmlw.close();
        String expected = "<a><![CDATA[<>'\"&abcd]]></a>";
        XmlWriterTest.check("<a><![CDATA[<>'\"&abcd]]></a>", writer);
    }

    @Test
    public void testInvalidNames() {
        Assertions.assertThrows(InvalidDataException.class, () -> {
            StringWriter writer = new StringWriter();
            try (XmlWriter xmlw = new XmlWriter((Writer)writer);){
                xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
                xmlw.beginElement("0");
            }
        });
        Assertions.assertThrows(InvalidDataException.class, () -> {
            StringWriter writer = new StringWriter();
            try (XmlWriter xmlw = new XmlWriter((Writer)writer);){
                xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
                xmlw.beginElement("a");
                xmlw.addAttribute("0", "");
            }
        });
    }

    @Test
    public void testInvalidContent() {
        Assertions.assertThrows(InvalidDataException.class, () -> {
            StringWriter writer = new StringWriter();
            try (XmlWriter xmlw = new XmlWriter((Writer)writer);){
                xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
                xmlw.beginElement("a");
                xmlw.addElementContent(new String(new byte[]{0}));
            }
        });
        Assertions.assertThrows(InvalidDataException.class, () -> {
            StringWriter writer = new StringWriter();
            try (XmlWriter xmlw = new XmlWriter((Writer)writer);){
                xmlw.setEnabled(new XmlWriter.Feature[]{XmlWriter.Feature.ALLOW_PARTIAL_XML});
                xmlw.beginElement("a");
                xmlw.addAttribute("a", new String(new byte[]{0}));
            }
        });
    }
}

