/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import cdc.util.xml.AbstractStAXParser;
import cdc.util.xml.StAXElementReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.stream.XMLStreamException;

public class StAXReading {
    private static final Map<Class<?>, StAXElementReader<?, ?>> map = new HashMap();

    public <T, C> void register(StAXElementReader<T, C> reader) {
        Checks.isNotNull(reader, (String)"reader");
        Checks.doesNotContainKey(map, reader.getObjectClass(), (String)"reader.getObjectClass()");
        map.put(reader.getObjectClass(), reader);
    }

    public <T, C> StAXElementReader<T, C> getElementReaderOrNull(Class<T> objectClass, Class<C> contextClass) {
        Checks.isNotNull(objectClass, (String)"objectClass");
        Checks.isNotNull(contextClass, (String)"contextClass");
        StAXElementReader<?, ?> result = map.get(objectClass);
        if (result != null) {
            Checks.assertTrue((boolean)result.getContextClass().isAssignableFrom(contextClass), (String)"Context class mismatch, expected: {}, found: {}", result.getContextClass(), contextClass);
        }
        return result;
    }

    public <T, D> StAXElementReader<T, D> getElementReader(Class<T> objectClass, Class<D> contextClass) {
        StAXElementReader<T, D> result = this.getElementReaderOrNull(objectClass, contextClass);
        return (StAXElementReader)NotFoundException.onResult(result, (String)("No reader found for " + objectClass.getCanonicalName()));
    }

    public <T, C> T parseElement(AbstractStAXParser<?> parser, Function<String, Class<? extends T>> nameToClass, C context) throws XMLStreamException {
        parser.expectStartElement("StAXReading.parseElement(...)");
        String name = parser.getReader().getLocalName();
        Class<? extends T> objectClass = nameToClass.apply(name);
        Class<?> contextClass = context.getClass();
        StAXElementReader<T, ?> reader = this.getElementReader(objectClass, contextClass);
        return reader.parseElementRaw(parser, context);
    }
}

