/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.strings.StringConversion;
import cdc.util.xml.XmlVersion;
import java.io.IOException;

public interface XmlHandler {
    public void beginDocument(XmlVersion var1) throws IOException;

    default public void beginDocument() throws IOException {
        this.beginDocument(XmlVersion.XML_1_0);
    }

    public void endDocument() throws IOException;

    default public void addDefaultNamespace(String uri) throws IOException {
        this.addAttribute("xmlns", uri);
    }

    default public void addNamespace(String prefix, String uri) throws IOException {
        this.addAttribute("xmlns:" + prefix, uri);
    }

    public void beginProcessingInstruction(String var1) throws IOException;

    public void addProcessingInstructionContent(String var1) throws IOException;

    public void endProcessingInstruction() throws IOException;

    public void addProcessingInstruction(String var1, String var2) throws IOException;

    default public void addStyleSheet(String xsl) throws IOException {
        this.beginProcessingInstruction("xml-stylesheet");
        this.addAttribute("type", "text/xsl");
        this.addAttribute("href", xsl);
        this.endProcessingInstruction();
    }

    public void beginComment() throws IOException;

    public void addCommentContent(String var1) throws IOException;

    public void endComment() throws IOException;

    default public void addComment(String content) throws IOException {
        this.beginComment();
        this.addCommentContent(content);
        this.endComment();
    }

    public void beginCData() throws IOException;

    public void addCDataContent(String var1) throws IOException;

    public void endCData() throws IOException;

    default public void addCData(String content) throws IOException {
        this.beginCData();
        this.addCDataContent(content);
        this.endCData();
    }

    public void beginElement(String var1) throws IOException;

    public void addElementContent(String var1) throws IOException;

    public void endElement() throws IOException;

    default public void addElement(String name, String content) throws IOException {
        this.beginElement(name);
        this.addElementContent(content);
        this.endElement();
    }

    default public void addElementIfNonEmpty(String name, String content) throws IOException {
        if (content != null && content.length() > 0) {
            this.addElement(name, content);
        }
    }

    public void addAttribute(String var1, String var2) throws IOException;

    default public void addAttribute(String name, Object value) throws IOException {
        if (value == null) {
            this.addAttribute(name, "");
        } else {
            this.addAttribute(name, value.toString());
        }
    }

    default public void addAttribute(String name, char value) throws IOException {
        this.addAttribute(name, Character.toString(value));
    }

    default public void addAttribute(String name, boolean value) throws IOException {
        this.addAttribute(name, StringConversion.asString((boolean)value));
    }

    default public void addAttribute(String name, long value) throws IOException {
        this.addAttribute(name, StringConversion.asString((long)value));
    }

    default public void addAttribute(String name, int value) throws IOException {
        this.addAttribute(name, StringConversion.asString((int)value));
    }

    default public void addAttribute(String name, short value) throws IOException {
        this.addAttribute(name, StringConversion.asString((short)value));
    }

    default public void addAttribute(String name, byte value) throws IOException {
        this.addAttribute(name, StringConversion.asString((byte)value));
    }

    default public void addAttribute(String name, double value) throws IOException {
        this.addAttribute(name, StringConversion.asString((double)value));
    }

    default public void addAttribute(String name, float value) throws IOException {
        this.addAttribute(name, StringConversion.asString((float)value));
    }
}

