/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.lang.FailureReaction;
import cdc.util.xml.IntSet;
import cdc.util.xml.XmlVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlUtils {
    private static final Logger LOGGER = LogManager.getLogger(XmlUtils.class);
    private static final IntSet XML_1_0_CHARS = new IntSet(9, 10, 13, 13, 32, 55295, 57344, 65533, 65536, 0x10FFFF);
    private static final IntSet XML_1_1_CHARS = new IntSet(1, 55295, 57344, 65533, 65536, 0x10FFFF);
    private static final IntSet XML_NAME_START_CHAR = new IntSet(58, 58, 65, 90, 95, 95, 97, 122, 192, 214, 216, 246, 248, 767, 880, 893, 895, 8191, 8204, 8205, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 64975, 65008, 65533, 65536, 983039);
    private static final IntSet XML_NAME_CHAR = new IntSet(45, 46, 48, 58, 65, 90, 95, 95, 97, 122, 183, 183, 192, 214, 216, 246, 248, 893, 895, 8191, 8204, 8205, 8255, 8256, 8304, 8591, 11264, 12271, 12289, 55295, 63744, 64975, 65008, 65533, 65536, 983039);

    private XmlUtils() {
    }

    private static boolean alwaysTrue(String s, CodePointEvaluator evaluator) {
        int codePoint;
        int length = s.length();
        for (int index = 0; index < length; index += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(index);
            if (evaluator.apply(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean alwaysTrue(char[] ch, int offset, int count, CodePointEvaluator evaluator) {
        int codePoint;
        for (int index = offset; index < offset + count; index += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(ch, index);
            if (evaluator.apply(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static String codePointToString(int codePoint) {
        StringBuilder builder = new StringBuilder();
        if (Character.isBmpCodePoint(codePoint)) {
            builder.append((char)codePoint);
        } else if (Character.isValidCodePoint(codePoint)) {
            builder.append(Character.highSurrogate(codePoint));
            builder.append(Character.lowSurrogate(codePoint));
        } else {
            builder.append('?');
        }
        return builder.toString();
    }

    public static boolean isWhiteSpace(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint == 32;
    }

    public static boolean isWhiteSpace(String s) {
        return s == null || XmlUtils.alwaysTrue(s, XmlUtils::isWhiteSpace);
    }

    public static boolean isWhiteSpace(char[] ch, int offset, int count) {
        return XmlUtils.alwaysTrue(ch, offset, count, XmlUtils::isWhiteSpace);
    }

    public static boolean isXml10Char(int codePoint) {
        return XML_1_0_CHARS.contains(codePoint);
    }

    public static boolean isXml11Char(int codePoint) {
        return XML_1_1_CHARS.contains(codePoint);
    }

    public static boolean isXmlChar(int codePoint, XmlVersion version) {
        return version == XmlVersion.XML_1_1 ? XmlUtils.isXml11Char(codePoint) : XmlUtils.isXml10Char(codePoint);
    }

    public static boolean isValidXml10(String s) {
        return s == null || XmlUtils.alwaysTrue(s, XmlUtils::isXml10Char);
    }

    public static boolean isValidXml11(String s) {
        return s == null || XmlUtils.alwaysTrue(s, XmlUtils::isXml11Char);
    }

    public static boolean isValidXml(String s, XmlVersion version) {
        return version == XmlVersion.XML_1_1 ? XmlUtils.isValidXml11(s) : XmlUtils.isValidXml10(s);
    }

    public static boolean isNameStartChar(int codePoint) {
        return XML_NAME_START_CHAR.contains(codePoint);
    }

    public static boolean isNameChar(int codePoint) {
        return XML_NAME_CHAR.contains(codePoint);
    }

    public static boolean isValidName(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int cp0 = s.codePointAt(0);
        if (!XmlUtils.isNameStartChar(cp0)) {
            return false;
        }
        return XmlUtils.alwaysTrue(s, XmlUtils::isNameChar);
    }

    public static String validate(String s, XmlVersion version, FailureReaction reaction, int def) {
        int codePoint;
        if (s == null) {
            return null;
        }
        if (XmlUtils.isValidXml(s, version)) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        int length = s.length();
        for (int index = 0; index < length; index += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(index);
            if (XmlUtils.isXmlChar(codePoint, version)) {
                builder.appendCodePoint(codePoint);
                continue;
            }
            if (reaction == FailureReaction.DEFAULT) {
                builder.appendCodePoint(def);
                continue;
            }
            String message = "Invalid xml character '" + XmlUtils.codePointToString(codePoint) + "'";
            if (reaction == FailureReaction.WARN) {
                builder.appendCodePoint(def);
                LOGGER.warn(message);
                continue;
            }
            throw new IllegalArgumentException(message);
        }
        return builder.toString();
    }

    public static String validate(String s, XmlVersion version, FailureReaction reaction) {
        return XmlUtils.validate(s, version, reaction, 63);
    }

    public static boolean needsEscape(String s, Context context, EscapingPolicy policy) {
        if (s != null) {
            int codePoint;
            int length = s.length();
            for (int index = 0; index < length; index += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(index);
                switch (codePoint) {
                    case 38: 
                    case 60: {
                        return true;
                    }
                    case 62: {
                        return policy == EscapingPolicy.ESCAPE_ALWAYS;
                    }
                    case 34: {
                        return policy == EscapingPolicy.ESCAPE_ALWAYS || context == Context.ATTRIBUTE_DOUBLE_QUOTE;
                    }
                    case 39: {
                        return policy == EscapingPolicy.ESCAPE_ALWAYS || context == Context.ATTRIBUTE_SINGLE_QUOTE;
                    }
                    case 9: 
                    case 10: 
                    case 13: {
                        return policy == EscapingPolicy.ESCAPE_ALWAYS && context.isAttribute();
                    }
                }
            }
        }
        return false;
    }

    public static String escape(String s, Context context, EscapingPolicy policy) {
        if (s != null) {
            StringBuilder builder = new StringBuilder();
            XmlUtils.appendEscaped(builder, s, context, policy);
            return builder.toString();
        }
        return s;
    }

    public static void appendEscaped(StringBuilder builder, String s, Context context, EscapingPolicy policy) {
        if (s != null) {
            int codePoint;
            int length = s.length();
            block10: for (int index = 0; index < length; index += Character.charCount(codePoint)) {
                codePoint = s.codePointAt(index);
                switch (codePoint) {
                    case 60: {
                        builder.append("&lt;");
                        continue block10;
                    }
                    case 38: {
                        builder.append("&amp;");
                        continue block10;
                    }
                    case 62: {
                        if (policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&gt;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    case 34: {
                        if (context == Context.ATTRIBUTE_DOUBLE_QUOTE || policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&quot;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    case 39: {
                        if (context == Context.ATTRIBUTE_SINGLE_QUOTE || policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&apos;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    case 10: {
                        if (context.isAttribute() && policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&#xA;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    case 9: {
                        if (context.isAttribute() && policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&#x9;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    case 13: {
                        if (context.isAttribute() && policy == EscapingPolicy.ESCAPE_ALWAYS) {
                            builder.append("&#xD;");
                            continue block10;
                        }
                        builder.appendCodePoint(codePoint);
                        continue block10;
                    }
                    default: {
                        builder.appendCodePoint(codePoint);
                    }
                }
            }
        }
    }

    public static enum EscapingPolicy {
        ESCAPE_IF_NECESSARY,
        ESCAPE_ALWAYS;

    }

    public static enum Context {
        ELEMENT,
        ATTRIBUTE_SINGLE_QUOTE,
        ATTRIBUTE_DOUBLE_QUOTE;


        public boolean isAttribute() {
            return this == ATTRIBUTE_SINGLE_QUOTE || this == ATTRIBUTE_DOUBLE_QUOTE;
        }
    }

    @FunctionalInterface
    private static interface CodePointEvaluator {
        public boolean apply(int var1);
    }
}

