/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml;

import cdc.util.lang.Checks;
import cdc.util.lang.NotFoundException;
import cdc.util.xml.XmlElementWriter;
import cdc.util.xml.XmlHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class XmlWriting {
    private final Map<Class<?>, XmlElementWriter<?, ?>> map = new HashMap();

    public <T, D> void register(XmlElementWriter<T, D> writer) {
        Checks.isNotNull(writer, (String)"writer");
        Checks.doesNotContainKey(this.map, writer.getObjectClass(), (String)"writer.getObjectClass()");
        this.map.put(writer.getObjectClass(), writer);
    }

    public <T, D> XmlElementWriter<T, D> getElementWriterOrNull(Class<T> objectClass, Class<D> dataClass) {
        Checks.isNotNull(objectClass, (String)"objectClass");
        Checks.isNotNull(dataClass, (String)"dataClass");
        XmlElementWriter<?, ?> result = this.map.get(objectClass);
        if (result != null) {
            Checks.assertTrue((boolean)dataClass.isAssignableFrom(result.getDataClass()), (String)"Data class mismatch, expected: {}, found: {}", dataClass, result.getDataClass());
        }
        return result;
    }

    public <T, D> XmlElementWriter<T, D> getElementWriter(Class<T> objectClass, Class<D> dataClass) {
        XmlElementWriter<T, D> result = this.getElementWriterOrNull(objectClass, dataClass);
        return (XmlElementWriter)NotFoundException.onResult(result, (String)("No printer found for " + objectClass.getCanonicalName()));
    }

    public void writeElement(XmlHandler handler, String name, Object object, Object data) throws IOException {
        Checks.isNotNull((Object)handler, (String)"handler");
        Checks.isNotNull((Object)name, (String)"name");
        XmlElementWriter<?, Object> result = this.getElementWriter(object.getClass(), Object.class);
        result.writeElementRaw(handler, name, object, data);
    }

    public void writeElement(XmlHandler handler, String name, Object object) throws IOException {
        this.writeElement(handler, name, object, null);
    }

    public <T> void writeElement(XmlHandler handler, Function<? super T, String> nameExtractor, T object, Object data) throws IOException {
        this.writeElement(handler, nameExtractor.apply(object), object, data);
    }

    public <T> void writeElement(XmlHandler handler, Function<? super T, String> nameExtractor, T object) throws IOException {
        this.writeElement(handler, nameExtractor, object, null);
    }

    public <T, D> void writeElement(XmlHandler handler, BiFunction<? super T, ? super D, String> nameExtractor, T object, D data) throws IOException {
        this.writeElement(handler, nameExtractor.apply(object, data), object, data);
    }

    public <T, D> void writeElement(XmlHandler handler, BiFunction<? super T, ? super D, String> nameExtractor, T object) throws IOException {
        this.writeElement(handler, nameExtractor.apply(object, null), object, null);
    }
}

