/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.files.Resources;
import cdc.util.function.IterableUtils;
import cdc.util.strings.StringUtils;
import cdc.util.xml.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlStats {
    protected static final Logger LOGGER = LogManager.getLogger(XmlStats.class);
    protected final MainArgs margs;

    private XmlStats(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Handler handler = new Handler();
        try {
            SAXParser parser = factory.newSAXParser();
            for (URL input : this.margs.inputs) {
                LOGGER.info("Analyze({})", (Object)input);
                parser.parse(input.openStream(), (DefaultHandler)handler);
            }
            handler.dump();
        }
        catch (ParserConfigurationException e) {
            LOGGER.trace((Object)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static void execute(MainArgs margs) throws Exception {
        XmlStats instance = new XmlStats(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private class Handler
    extends DefaultHandler {
        private final Map<String, Integer> counts = new HashMap<String, Integer>();
        private final List<String> namesStack = new ArrayList<String>();
        private final List<String> pathsStack = new ArrayList<String>();

        private String getPathKind(String path) {
            if (path.indexOf(64) != -1) {
                return "ATTRIBUTE";
            }
            if (path.indexOf("()") == -1) {
                return "ELEMENT";
            }
            return "TEXT";
        }

        private int getPathDepth(String path) {
            int slashes = StringUtils.countMatches((String)path, (char)'/');
            int arobases = StringUtils.countMatches((String)path, (char)'@');
            return slashes + arobases;
        }

        private void push(String name) {
            this.namesStack.add(name);
            if (this.namesStack.size() == 1) {
                this.pathsStack.add("/" + name);
            } else {
                this.pathsStack.add(this.pathsStack.get(this.pathsStack.size() - 1) + "/" + name);
            }
        }

        private void pop() {
            this.namesStack.remove(this.namesStack.size() - 1);
            this.pathsStack.remove(this.pathsStack.size() - 1);
        }

        private String getPath() {
            if (this.pathsStack.isEmpty()) {
                return "/";
            }
            return this.pathsStack.get(this.pathsStack.size() - 1);
        }

        private void add(String name) {
            String qname;
            String path = this.getPath();
            String string = qname = name == null ? path : path + name;
            if (this.counts.containsKey(qname)) {
                this.counts.put(qname, this.counts.get(qname) + 1);
            } else {
                this.counts.put(qname, 1);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.push(qName);
            this.add(null);
            for (int index = 0; index < attributes.getLength(); ++index) {
                this.add("@" + attributes.getQName(index));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.pop();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!XmlUtils.isWhiteSpace(ch, start, length)) {
                this.add("/text()");
            }
        }

        public void dump() throws FileNotFoundException {
            LOGGER.info("Generate: {}", (Object)XmlStats.this.margs.output);
            try (PrintStream out = new PrintStream(XmlStats.this.margs.output);){
                out.println("path;kind;depth;count");
                for (String path : IterableUtils.toSortedList(this.counts.keySet())) {
                    out.println(path + ";" + this.getPathKind(path) + ";" + this.getPathDepth(path) + ";" + this.counts.get(path));
                }
            }
            LOGGER.info("Done");
        }
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        public MainSupport() {
            super(XmlStats.class, LOGGER);
        }

        protected String getVersion() {
            return "0.9.0";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt("input").desc("Name(s) of the XML input(s) <URL/FILE>.").hasArgs().required().build());
            options.addOption(Option.builder().longOpt("output").desc("Name of the CSV <FILE> to generate.").hasArg().required().build());
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            for (String input : cl.getOptionValues("input")) {
                URL url = Resources.getResource((String)input);
                if (url == null) {
                    throw new ParseException("Invalid url: " + input);
                }
                margs.inputs.add(url);
            }
            margs.output = MainSupport.getValueAsFile((CommandLine)cl, (String)"output", null);
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            XmlStats.execute(margs);
            return null;
        }
    }

    public static class MainArgs {
        public final List<URL> inputs = new ArrayList<URL>();
        public File output;
    }
}

