/*
 * Decompiled with CFR 0.152.
 */
package cdc.util.xml.tools;

import cdc.util.cli.AbstractMainSupport;
import cdc.util.files.Files;
import cdc.util.files.Resources;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class XmlToHtml {
    protected static final Logger LOGGER = LogManager.getLogger(XmlToHtml.class);
    private final MainArgs margs;

    private XmlToHtml(MainArgs margs) {
        this.margs = margs;
    }

    private void execute() throws Exception {
        LOGGER.info("Convert '{}'", (Object)this.margs.xml);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("xslt: {} {}", (Object)this.margs.xslt, (Object)this.margs.xslt.toExternalForm());
        }
        try (InputStream xmlInput = this.margs.xml.openStream();
             InputStream xsltInput = this.margs.xslt.openStream();){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(new ClasspathURIResolver());
            StreamSource xmlSource = new StreamSource(xmlInput, this.margs.xml.toExternalForm());
            StreamSource xsltSource = new StreamSource(xsltInput, this.margs.xslt.toExternalForm());
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("indent", "yes");
            for (Map.Entry<String, String> entry : this.margs.params.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            File file = this.margs.output;
            StreamResult result = new StreamResult(new BufferedOutputStream(new FileOutputStream(file)));
            result.setSystemId(URLDecoder.decode(file.toURI().toURL().toString(), "UTF-8"));
            transformer.transform(xmlSource, result);
            LOGGER.info("Conversion done into: {}", (Object)result.getSystemId());
        }
        catch (IOException | TransformerException e) {
            LOGGER.catching((Throwable)e);
            throw e;
        }
    }

    public static void execute(MainArgs margs) throws Exception {
        XmlToHtml instance = new XmlToHtml(margs);
        instance.execute();
    }

    public static void main(String[] args) {
        MainSupport support = new MainSupport();
        support.main(args);
    }

    private static class MainSupport
    extends AbstractMainSupport<MainArgs, Void> {
        private static final String XML = "xml";
        private static final String XSLT = "xslt";
        private static final String PARAM = "param";

        public MainSupport() {
            super(XmlToHtml.class, LOGGER);
        }

        protected String getVersion() {
            return "0.9.0";
        }

        protected void addSpecificOptions(Options options) {
            options.addOption(Option.builder().longOpt(XML).desc("Name of the XML input <URL/FILE>.").hasArg().required().build());
            options.addOption(Option.builder().longOpt(XSLT).desc("Name of the <URL/FILE> containing the XSLT to apply.").hasArg().required().build());
            options.addOption(Option.builder().longOpt("output").desc("Name of the HTML <FILE> to generate.").hasArg().build());
            options.addOption(Option.builder().longOpt(PARAM).desc("Parameter(s) (name=value) to be passed to the transformation.").hasArgs().build());
        }

        private static void addParam(MainArgs margs, String s) throws ParseException {
            int pos = s.indexOf(61);
            if (pos < 0) {
                throw new ParseException("Invalid param '" + s + "'");
            }
            String name = s.substring(0, pos);
            String value = pos + 1 < s.length() ? s.substring(pos + 1) : "";
            margs.params.put(name, value);
        }

        protected MainArgs analyze(CommandLine cl) throws ParseException {
            MainArgs margs = new MainArgs();
            margs.xml = Resources.getResource((String)cl.getOptionValue(XML));
            if (margs.xml == null) {
                throw new ParseException("Invalid xml: " + margs.xml);
            }
            margs.xslt = Resources.getResource((String)cl.getOptionValue(XSLT));
            if (margs.xml == null) {
                throw new ParseException("Invalid xslt: " + margs.xslt);
            }
            if (cl.hasOption("output")) {
                margs.output = new File(cl.getOptionValue("output"));
            }
            if (cl.hasOption(PARAM)) {
                for (String s : cl.getOptionValues(PARAM)) {
                    MainSupport.addParam(margs, s);
                }
            }
            return margs;
        }

        protected Void execute(MainArgs margs) throws Exception {
            XmlToHtml.execute(margs);
            return null;
        }
    }

    private static class ClasspathURIResolver
    implements URIResolver {
        private static final Logger LOGGER = LogManager.getLogger(ClasspathURIResolver.class);

        private static String decode(String s) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("decode({}) Failed, {}", (Object)s, (Object)e.getMessage());
                return s;
            }
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            LOGGER.trace("resolve({}, {})", (Object)href, (Object)base);
            URL url = Resources.getResource((String)ClasspathURIResolver.decode(href), (boolean)false);
            if (url != null) {
                try {
                    return new StreamSource(url.openStream(), url.toExternalForm());
                }
                catch (IOException e) {
                    throw new TransformerException(e);
                }
            }
            if (base != null) {
                try {
                    URI baseUri = new URI(base);
                    URL baseUrl = baseUri.toURL();
                    if ("file".equals(baseUrl.getProtocol())) {
                        File file = new File(baseUri);
                        LOGGER.trace("file: {}", (Object)file);
                        throw new TransformerException("NYI");
                    }
                    if ("jar".equals(baseUrl.getProtocol())) {
                        String file = baseUrl.getPath().substring(baseUrl.getPath().indexOf(33) + 1);
                        File basePath = new File(Files.getDirname((String)file));
                        LOGGER.trace("file: {} {}", (Object)file, (Object)basePath);
                        File x = new File(basePath, href);
                        URL url2 = Resources.getResource((String)x.getPath());
                        LOGGER.trace("url: {}", (Object)url2);
                        return new StreamSource(url2.openStream(), url2.toExternalForm());
                    }
                    throw new TransformerException("Unsupported protocol");
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.catching((Throwable)e);
                }
            }
            return null;
        }
    }

    public static class MainArgs {
        public URL xml;
        public URL xslt;
        public File output;
        public final Map<String, String> params = new HashMap<String, String>();
    }
}

