/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.google.auto.value.AutoValue;
import com.sun.source.tree.CompilationUnitTree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import stack.source.internal.AutoValue_Index;
import stack.source.internal.IndexRegion;

@AutoValue
abstract class Index {
    private static final byte VERSION = 1;

    Index() {
    }

    static Index create(Path source, NavigableSet<IndexRegion> regions) {
        return new AutoValue_Index(source.toAbsolutePath(), Collections.unmodifiableNavigableSet(regions));
    }

    abstract Path source();

    abstract NavigableSet<IndexRegion> regions();

    private static String relativePath(String pkgName, String fileName) {
        return String.join((CharSequence)"/", "stack-source", pkgName, fileName + ".index");
    }

    static String relativePath(StackTraceElement element) {
        String pkgName = Index.getPackageName(element);
        String fileName = element.getFileName();
        return Index.relativePath(pkgName, fileName);
    }

    static Optional<Index> read(StackTraceElement element) throws IOException {
        String resource = Index.relativePath(element);
        try (InputStream in = Index.class.getClassLoader().getResourceAsStream(resource);){
            if (in == null) {
                Optional<Index> optional = Optional.empty();
                return optional;
            }
            DataInputStream data = new DataInputStream(new BufferedInputStream(in));
            Optional<Index> optional = Index.read(data);
            return optional;
        }
    }

    private static String getPackageName(StackTraceElement element) {
        String className = element.getClassName();
        int pkgNameEnd = className.lastIndexOf(46);
        if (pkgNameEnd > 0) {
            return className.substring(0, pkgNameEnd);
        }
        return "";
    }

    private static Optional<Index> read(DataInput in) throws IOException {
        if (in.readByte() != 1) {
            return Optional.empty();
        }
        Path source = Paths.get(in.readUTF(), new String[0]);
        int count = in.readInt();
        TreeSet<IndexRegion> regions = new TreeSet<IndexRegion>();
        for (int i = 0; i < count; ++i) {
            regions.add(IndexRegion.read(in));
        }
        return Optional.of(Index.create(source, regions));
    }

    void write(ProcessingEnvironment env, CompilationUnitTree src) throws IOException {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Index.createIndexFile(env, src).openOutputStream()));){
            this.write(out);
        }
    }

    private void write(DataOutput out) throws IOException {
        out.writeByte(1);
        out.writeUTF(this.source().toString());
        out.writeInt(this.regions().size());
        for (IndexRegion element : this.regions()) {
            element.write(out);
        }
    }

    private static FileObject createIndexFile(ProcessingEnvironment env, CompilationUnitTree unit) throws IOException {
        String name = new File(unit.getSourceFile().getName()).getName();
        return env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", Index.relativePath(unit.getPackageName().toString(), name), new Element[0]);
    }
}

