/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.google.auto.value.AutoValue;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import stack.source.internal.AutoValue_IndexRegion;

@AutoValue
abstract class IndexRegion
implements Comparable<IndexRegion> {
    private static final Comparator<IndexRegion> comparator = Comparator.comparing(IndexRegion::startLineNum).thenComparing(IndexRegion::endLineNum).thenComparing(IndexRegion::startLineStartPos);

    IndexRegion() {
    }

    static IndexRegion create(long startLineNum, long endLineNum, long startLineStartPos) {
        long lineCount = endLineNum - startLineNum;
        if (lineCount < 0L) {
            throw new IllegalArgumentException("startLineNum=" + startLineNum + ", endLineNum=" + endLineNum);
        }
        return new AutoValue_IndexRegion(startLineNum, endLineNum, startLineStartPos);
    }

    abstract long startLineNum();

    abstract long endLineNum();

    abstract long startLineStartPos();

    @Override
    public int compareTo(IndexRegion o) {
        return comparator.compare(this, o);
    }

    List<String> lines(Path path) throws IOException {
        long lineCount = this.endLineNum() - this.startLineNum() + 1L;
        try (BufferedReader in = Files.newBufferedReader(path);){
            if (in.skip(this.startLineStartPos()) != this.startLineStartPos()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = in.lines().limit(lineCount).collect(Collectors.toList());
            return list;
        }
    }

    static IndexRegion read(DataInput in) throws IOException {
        long startLineNum = in.readLong();
        long endLineNum = in.readLong();
        long startLineStartPos = in.readLong();
        return IndexRegion.create(startLineNum, endLineNum, startLineStartPos);
    }

    void write(DataOutput out) throws IOException {
        out.writeLong(this.startLineNum());
        out.writeLong(this.endLineNum());
        out.writeLong(this.startLineStartPos());
    }
}

