/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import stack.source.internal.Scanner;
import stack.source.internal.Throwables;

public final class Processor
extends AbstractProcessor {
    private final Set<CompilationUnitTree> units = new HashSet<CompilationUnitTree>();
    private Trees trees;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment process) {
        super.init(process);
        this.trees = Trees.instance(process);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        try {
            this.doProcess(round);
        }
        catch (Throwable e) {
            this.logWarning(e);
        }
        return false;
    }

    private void doProcess(RoundEnvironment round) throws IOException {
        if (round.processingOver()) {
            this.processCompilationUnits();
        } else {
            this.collectCompilationUnits(round);
        }
    }

    private void collectCompilationUnits(RoundEnvironment roundEnv) {
        roundEnv.getRootElements().stream().map(this.trees::getPath).map(TreePath::getCompilationUnit).forEach(this.units::add);
    }

    private void processCompilationUnits() throws IOException {
        for (CompilationUnitTree unit : this.units) {
            Scanner writer = new Scanner(this.processingEnv, unit);
            Throwable throwable = null;
            try {
                writer.scan(unit, this.trees);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
        this.units.clear();
    }

    private void logWarning(Throwable e) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, Throwables.getStackTraceAsString(e));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

