/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import stack.source.internal.Index;
import stack.source.internal.IndexRegion;

final class Scanner
extends TreePathScanner<Void, Trees>
implements Closeable {
    private final ProcessingEnvironment env;
    private final CompilationUnitTree src;
    private final NavigableSet<IndexRegion> regions;

    Scanner(ProcessingEnvironment env, CompilationUnitTree src) {
        this.env = Objects.requireNonNull(env);
        this.src = Objects.requireNonNull(src);
        this.regions = new TreeSet<IndexRegion>();
    }

    @Override
    public void close() throws IOException {
        URI uri = this.src.getSourceFile().toUri();
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            Path source = Paths.get(uri).toAbsolutePath();
            Index.create(source, this.regions).write(this.env, this.src);
        }
    }

    @Override
    public Void visitNewClass(NewClassTree node, Trees trees) {
        super.visitNewClass(node, trees);
        this.add(node, trees);
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree node, Trees trees) {
        super.visitThrow(node, trees);
        this.add(node, trees);
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, Trees trees) {
        super.visitExpressionStatement(node, trees);
        this.add(node, trees);
        return null;
    }

    private void add(Tree node, Trees trees) {
        SourcePositions positions = trees.getSourcePositions();
        CompilationUnitTree unit = this.getCurrentPath().getCompilationUnit();
        LineMap lineMap = unit.getLineMap();
        if (lineMap == null) {
            return;
        }
        long startPos = positions.getStartPosition(unit, node);
        long endPos = positions.getEndPosition(unit, node);
        if (startPos == -1L || endPos == -1L) {
            return;
        }
        long endLineNum = lineMap.getLineNumber(endPos);
        long startLineNum = lineMap.getLineNumber(startPos);
        long startLineStartPos = lineMap.getStartPosition(startLineNum);
        this.regions.add(IndexRegion.create(startLineNum, endLineNum, startLineStartPos));
    }
}

