/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import stack.source.internal.Index;
import stack.source.internal.IndexRegion;

final class Scanner
extends TreePathScanner<Void, Trees>
implements Closeable {
    private final ProcessingEnvironment env;
    private final CompilationUnitTree src;
    private final Set<IndexRegion> regions;

    Scanner(ProcessingEnvironment env, CompilationUnitTree src) {
        this.env = Objects.requireNonNull(env);
        this.src = Objects.requireNonNull(src);
        this.regions = new HashSet<IndexRegion>();
    }

    @Override
    public void close() throws IOException {
        URI uri = this.src.getSourceFile().toUri();
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            Path source = Paths.get(uri).toAbsolutePath();
            Index.create(source, this.regions).write(this.env, this.src);
        }
    }

    @Override
    public Void visitMethod(MethodTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitMethod(node, trees);
    }

    @Override
    public Void visitBlock(BlockTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitBlock(node, trees);
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitDoWhileLoop(node, trees);
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitWhileLoop(node, trees);
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitForLoop(node, trees);
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitEnhancedForLoop(node, trees);
    }

    @Override
    public Void visitSwitch(SwitchTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitSwitch(node, trees);
    }

    @Override
    public Void visitCase(CaseTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitCase(node, trees);
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitSynchronized(node, trees);
    }

    @Override
    public Void visitTry(TryTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitTry(node, trees);
    }

    @Override
    public Void visitCatch(CatchTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitCatch(node, trees);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitConditionalExpression(node, trees);
    }

    @Override
    public Void visitIf(IfTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitIf(node, trees);
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatementTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitExpressionStatement(node, trees);
    }

    @Override
    public Void visitThrow(ThrowTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitThrow(node, trees);
    }

    @Override
    public Void visitAssert(AssertTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitAssert(node, trees);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitMethodInvocation(node, trees);
    }

    @Override
    public Void visitNewClass(NewClassTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitNewClass(node, trees);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitNewArray(node, trees);
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitLambdaExpression(node, trees);
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitAssignment(node, trees);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitCompoundAssignment(node, trees);
    }

    @Override
    public Void visitUnary(UnaryTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitUnary(node, trees);
    }

    @Override
    public Void visitBinary(BinaryTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitBinary(node, trees);
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitTypeCast(node, trees);
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitInstanceOf(node, trees);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Trees trees) {
        this.add(node, trees);
        return (Void)super.visitArrayAccess(node, trees);
    }

    private void add(Tree node, Trees trees) {
        SourcePositions positions = trees.getSourcePositions();
        CompilationUnitTree unit = this.getCurrentPath().getCompilationUnit();
        LineMap lineMap = unit.getLineMap();
        if (lineMap == null) {
            return;
        }
        long startPos = positions.getStartPosition(unit, node);
        long endPos = positions.getEndPosition(unit, node);
        if (startPos == -1L || endPos == -1L) {
            return;
        }
        long endLineNum = lineMap.getLineNumber(endPos);
        long startLineNum = lineMap.getLineNumber(startPos);
        long startLineStartPos = lineMap.getStartPosition(startLineNum);
        this.regions.add(IndexRegion.create(startLineNum, endLineNum, startLineStartPos));
    }
}

