/*
 * Decompiled with CFR 0.152.
 */
package stack.source.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import stack.source.internal.Index;
import stack.source.internal.IndexRegion;
import stack.source.internal.Throwables;

public final class Decorator {
    private Decorator() {
    }

    public static void printSafely(Throwable throwable, PrintStream out) {
        Decorator.printSafely(throwable, new PrintWriter(out));
    }

    public static void printSafely(Throwable throwable, PrintWriter out) {
        try {
            out.println(Decorator.print(throwable));
        }
        catch (Throwable e) {
            throwable.printStackTrace(out);
            Logger.getLogger(Decorator.class.getName()).warning(() -> "Failed to decorate " + Throwables.getStackTraceAsString(e));
        }
    }

    public static String print(Throwable throwable) {
        HashMap decorations = new HashMap();
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getFileName() == null) continue;
            Decorator.read(element).ifPresent(entry -> {
                Index index = (Index)entry.getKey();
                IndexRegion region = (IndexRegion)entry.getValue();
                decorations.computeIfAbsent(element.getFileName(), __ -> new HashMap()).computeIfAbsent(region, r -> new Decoration(element, index, (IndexRegion)r));
            });
        }
        String stackTrace = Throwables.getStackTraceAsString(throwable);
        for (Map values : decorations.values()) {
            for (Decoration decoration : values.values()) {
                stackTrace = decoration.decorate(stackTrace);
            }
        }
        return stackTrace;
    }

    private static Optional<Map.Entry<Index, IndexRegion>> read(StackTraceElement stack) {
        return Index.read(stack).flatMap(index -> Decorator.findRegion(stack, index).map(region -> new AbstractMap.SimpleEntry<Index, IndexRegion>((Index)index, (IndexRegion)region)));
    }

    private static Optional<IndexRegion> findRegion(StackTraceElement stack, Index index) {
        return index.regions().stream().filter(e -> (long)stack.getLineNumber() >= e.startLineNum()).filter(e -> (long)stack.getLineNumber() <= e.endLineNum()).sorted(Comparator.comparing(IndexRegion::lineCount)).reduce((a, b) -> a.lineCount() <= 2L && b.lineCount() <= 10L ? b : a);
    }

    private static final class Decoration {
        final StackTraceElement element;
        final Index index;
        final IndexRegion region;

        Decoration(StackTraceElement element, Index index, IndexRegion region) {
            this.element = Objects.requireNonNull(element);
            this.index = Objects.requireNonNull(index);
            this.region = Objects.requireNonNull(region);
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            int width = String.valueOf(this.region.endLineNum()).length();
            long lineNumber = this.region.startLineNum();
            for (String line : this.region.lines(this.index.source())) {
                out.append("\t");
                out.append(lineNumber == (long)this.element.getLineNumber() ? "-> " : "   ");
                out.append(String.format("%" + width + "d", lineNumber));
                out.append("  ");
                out.append(line);
                out.append(System.lineSeparator());
                ++lineNumber;
            }
            return out.toString();
        }

        String decorate(String stackTrace) {
            String line = this.element.toString();
            return stackTrace.replace(line, line + System.lineSeparator() + System.lineSeparator() + this.toString() + System.lineSeparator());
        }
    }
}

