/*
 * Decompiled with CFR 0.152.
 */
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;

public class PluginLoader {
    public <OBJECT> OBJECT load(String plugin, Class<OBJECT> pluginInterface) throws LoadingException {
        File tempDir = null;
        File sourceFile = null;
        try {
            JavaParser javaParser = new JavaParser();
            ParseResult parseResult = javaParser.parse(plugin);
            if (!parseResult.isSuccessful()) {
                StringBuilder message = new StringBuilder();
                message.append("Parsing source file failed:\n");
                parseResult.getProblems().forEach(problem -> message.append(String.format("%s\n", problem.getVerboseMessage())));
                throw new LoadingException(message.toString());
            }
            assert (parseResult.getResult().isPresent());
            Set publicTopLevelClasses = ((CompilationUnit)parseResult.getResult().get()).getTypes().stream().filter(TypeDeclaration::isTopLevelType).filter(typeDeclaration -> !typeDeclaration.getModifiers().contains((Node)Modifier.privateModifier())).filter(typeDeclaration -> !typeDeclaration.getModifiers().contains((Node)Modifier.protectedModifier())).collect(Collectors.toSet());
            if (publicTopLevelClasses.isEmpty()) {
                throw new LoadingException("Did not found a public top level class in the source code");
            }
            if (publicTopLevelClasses.size() > 1) {
                throw new LoadingException("Found multiple public top level classes in the source code");
            }
            tempDir = new File(Long.toString(System.nanoTime())).getAbsoluteFile();
            Files.createDirectory(tempDir.toPath(), new FileAttribute[0]);
            if (!tempDir.exists()) {
                throw new LoadingException("Could not create temp directory: " + tempDir.getAbsolutePath());
            }
            String className = ((TypeDeclaration)publicTopLevelClasses.iterator().next()).getName().asString();
            sourceFile = new File(tempDir, String.format("%s.java", className)).getAbsoluteFile();
            Files.createFile(sourceFile.toPath(), new FileAttribute[0]);
            if (!sourceFile.exists()) {
                throw new LoadingException(String.format("Could not create temp file: %s", sourceFile.getAbsolutePath()));
            }
            try (DataOutputStream outputStream = new DataOutputStream(new FileOutputStream(sourceFile));){
                outputStream.writeBytes(plugin);
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            compiler.run(null, null, null, sourceFile.getAbsolutePath());
            File classFile = sourceFile.toPath().getParent().resolve(String.format("%s.class", className)).toFile();
            OBJECT classObject = this.load(pluginInterface, classFile);
            FileUtils.deleteDirectory((File)tempDir);
            if (sourceFile.exists()) {
                throw new LoadingException(String.format("Could not delete temp file: %s", sourceFile.getAbsolutePath()));
            }
            if (tempDir.exists()) {
                throw new LoadingException(String.format("Could not delete temp directory: %s", tempDir.getAbsolutePath()));
            }
            return classObject;
        }
        catch (LoadingException e) {
            try {
                if (tempDir != null) {
                    FileUtils.deleteDirectory(tempDir);
                }
                if (sourceFile != null && sourceFile.exists()) {
                    throw new LoadingException(String.format("Could not delete temp file: %s", sourceFile.getAbsolutePath()));
                }
                if (tempDir != null && tempDir.exists()) {
                    throw new LoadingException(String.format("Could not delete temp directory: %s", tempDir.getAbsolutePath()));
                }
                throw new LoadingException(e);
            }
            catch (IOException a) {
                throw new LoadingException(a);
            }
        }
        catch (IOException e) {
            throw new LoadingException(e);
        }
    }

    public <OBJECT> OBJECT load(Class<OBJECT> pluginInterface, File plugin) throws LoadingException {
        try {
            String className = this.getClassName(plugin);
            URL classUrl = plugin.getParentFile().toURI().toURL();
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{classUrl});
            classLoader.loadClass(className);
            Class<?> compiledClass = Class.forName(className, false, classLoader);
            if (!pluginInterface.isAssignableFrom(compiledClass)) {
                throw new LoadingException(String.format("Public class %s in the source code can not be assigned to %s", className, pluginInterface.getCanonicalName()));
            }
            if (Arrays.asList(compiledClass.getConstructors()).parallelStream().noneMatch(constructor -> constructor.getParameterCount() == 0)) {
                throw new LoadingException(String.format("Public class %s in the source code has no constructor without arguments", className));
            }
            Object result = compiledClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (OBJECT)result;
        }
        catch (ReflectiveOperationException | MalformedURLException e) {
            throw new LoadingException(e);
        }
    }

    private String getClassName(File plugin) {
        return plugin.getName().substring(0, plugin.getName().indexOf("."));
    }

    public static class LoadingException
    extends Exception {
        public LoadingException(String message) {
            super(message);
        }

        public LoadingException(Throwable cause) {
            super(cause);
        }
    }
}

