/*
 * Decompiled with CFR 0.152.
 */
package pluginloader;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pluginloader.load.PluginClassLoader;
import pluginloader.load.PluginCompiler;

public class PluginLoader {
    public <OBJECT> OBJECT load(String plugin, Class<OBJECT> pluginInterface) throws LoadingException {
        try {
            ClassInfo classInfo = this.parseClassInfo(plugin);
            byte[] compile = PluginCompiler.compile(classInfo.getFullQualifiedClassName(), plugin);
            PluginClassLoader pluginClassLoader = new PluginClassLoader();
            pluginClassLoader.putClassCode(classInfo.getFullQualifiedClassName(), compile);
            Class<?> pluginClass = pluginClassLoader.findClass(classInfo.getFullQualifiedClassName());
            if (!pluginInterface.isAssignableFrom(pluginClass)) {
                throw new LoadingException(String.format("The compiled class is no implementation or subclass of %s", pluginInterface.getCanonicalName()));
            }
            Object pluginInstance = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (OBJECT)pluginInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PluginCompiler.CompilationFailedException e) {
            throw new LoadingException(e);
        }
    }

    private ClassInfo parseClassInfo(String plugin) throws LoadingException {
        CompilationUnit compilationUnit;
        Optional packageDeclaration;
        JavaParser javaParser = new JavaParser();
        ParseResult parseResult = javaParser.parse(plugin);
        if (!parseResult.isSuccessful()) {
            StringBuilder message = new StringBuilder();
            message.append("Parsing source file failed:\n");
            parseResult.getProblems().forEach(problem -> message.append(String.format("%s\n", problem.getVerboseMessage())));
            throw new LoadingException(message.toString());
        }
        assert (parseResult.getResult().isPresent());
        Set publicTopLevelClasses = ((CompilationUnit)parseResult.getResult().get()).getTypes().stream().filter(TypeDeclaration::isTopLevelType).filter(typeDeclaration -> !typeDeclaration.getModifiers().contains((Node)Modifier.privateModifier())).filter(typeDeclaration -> !typeDeclaration.getModifiers().contains((Node)Modifier.protectedModifier())).collect(Collectors.toSet());
        if (publicTopLevelClasses.isEmpty()) {
            throw new LoadingException("Did not found a public top level class in the source code");
        }
        if (publicTopLevelClasses.size() > 1) {
            throw new LoadingException("Found multiple public top level classes in the source code");
        }
        String className = ((TypeDeclaration)publicTopLevelClasses.iterator().next()).getName().asString();
        String packageName = null;
        Optional parentNode = ((TypeDeclaration)publicTopLevelClasses.iterator().next()).getParentNode();
        if ((parentNode.isPresent() || parentNode.get() instanceof CompilationUnit) && (packageDeclaration = (compilationUnit = (CompilationUnit)parentNode.get()).getPackageDeclaration()).isPresent()) {
            packageName = ((PackageDeclaration)packageDeclaration.get()).getNameAsString();
        }
        return new ClassInfo(className, packageName);
    }

    private static class ClassInfo {
        private final String className;
        private final String packageName;

        private ClassInfo(String className, String packageName) {
            this.className = className;
            this.packageName = packageName;
        }

        public String getFullQualifiedClassName() {
            String packagePath = "";
            if (this.packageName != null) {
                packagePath = String.format("%s.", this.packageName);
            }
            return String.format("%s%s", packagePath, this.className);
        }
    }

    public static class LoadingException
    extends Exception {
        public LoadingException(String message) {
            super(message);
        }

        public LoadingException(Throwable cause) {
            super(cause);
        }
    }
}

