/*
 * Decompiled with CFR 0.152.
 */
package pluginloader;

import java.lang.reflect.InvocationTargetException;
import pluginloader.ClassInfo;
import pluginloader.load.PluginClassLoader;
import pluginloader.load.PluginCompiler;
import pluginloader.load.SourceCodeParser;

public class PluginLoader {
    public <OBJECT> OBJECT load(String plugin, Class<OBJECT> pluginInterface) throws LoadingException {
        try {
            ClassInfo classInfo = new SourceCodeParser().parseClassInfo(plugin);
            byte[] compile = PluginCompiler.compile(classInfo.getFullQualifiedClassName(), plugin);
            PluginClassLoader pluginClassLoader = new PluginClassLoader();
            pluginClassLoader.putClassCode(classInfo.getFullQualifiedClassName(), compile);
            Class<?> pluginClass = pluginClassLoader.findClass(classInfo.getFullQualifiedClassName());
            if (!pluginInterface.isAssignableFrom(pluginClass)) {
                throw new LoadingException(String.format("The compiled class is no implementation or subclass of %s", pluginInterface.getCanonicalName()));
            }
            Object pluginInstance = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (OBJECT)pluginInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | PluginCompiler.CompilationFailedException e) {
            throw new LoadingException(e);
        }
    }

    public static class LoadingException
    extends Exception {
        public LoadingException(String message) {
            super(message);
        }

        public LoadingException(Throwable cause) {
            super(cause);
        }
    }
}

