/*
 * Decompiled with CFR 0.152.
 */
package pluginloader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import pluginloader.ClassInfo;
import pluginloader.load.PluginClassLoader;
import pluginloader.load.PluginCompiler;
import pluginloader.load.SourceCodeParser;

public class PluginLoader {
    public <OBJECT> OBJECT load(JarInputStream jarInputStream, Class<OBJECT> pluginInterface) throws LoadingException {
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        try {
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                if (!jarEntry.isDirectory()) {
                    entries.put(jarEntry.getRealName(), jarInputStream.readAllBytes());
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        catch (IOException exception) {
            throw new LoadingException(exception);
        }
        String pluginClassSpecificationFile = String.format("META-INF/services/%s", pluginInterface.getCanonicalName());
        if (!entries.containsKey(pluginClassSpecificationFile)) {
            throw new WrongFileFormatException(String.format("Expected JAR to contain file '%s'", pluginClassSpecificationFile));
        }
        List pluginClassSpecificationFileLines = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])entries.get(pluginClassSpecificationFile)))).lines().collect(Collectors.toList());
        if (pluginClassSpecificationFileLines.isEmpty()) {
            throw new WrongFileFormatException(String.format("File is empty: %s", pluginClassSpecificationFile));
        }
        if (pluginClassSpecificationFileLines.size() > 1) {
            throw new WrongFileFormatException(String.format("File contains more than one lines: %s", pluginClassSpecificationFile));
        }
        String pluginClassName = (String)pluginClassSpecificationFileLines.get(0);
        PluginClassLoader pluginClassLoader = new PluginClassLoader();
        entries.entrySet().stream().filter(file -> ((String)file.getKey()).endsWith(".class")).forEach(file -> {
            String className = ((String)file.getKey()).replace(".class", "").replace("/", ".");
            pluginClassLoader.putClassCode(className, (byte[])file.getValue());
        });
        try {
            Class<?> pluginClass = pluginClassLoader.findClass(pluginClassName);
            return this.createInstance(pluginInterface, pluginClass);
        }
        catch (ClassNotFoundException e) {
            throw new LoadingException(String.format("Did not find class to load: '%s'\nPlease check if it is contained in the provided JAR", pluginClassName));
        }
    }

    public <OBJECT> OBJECT load(String plugin, Class<OBJECT> pluginInterface) throws LoadingException {
        try {
            ClassInfo classInfo = new SourceCodeParser().parseClassInfo(plugin);
            byte[] compile = PluginCompiler.compile(classInfo.getFullQualifiedClassName(), plugin);
            PluginClassLoader pluginClassLoader = new PluginClassLoader();
            pluginClassLoader.putClassCode(classInfo.getFullQualifiedClassName(), compile);
            Class<?> pluginClass = pluginClassLoader.findClass(classInfo.getFullQualifiedClassName());
            return this.createInstance(pluginInterface, pluginClass);
        }
        catch (ClassNotFoundException | PluginCompiler.CompilationFailedException e) {
            throw new LoadingException(e);
        }
    }

    private <OBJECT> OBJECT createInstance(Class<OBJECT> pluginInterface, Class<?> pluginClass) throws LoadingException {
        if (!pluginInterface.isAssignableFrom(pluginClass)) {
            throw new LoadingException(String.format("The compiled class is no implementation or subclass of %s", pluginInterface.getCanonicalName()));
        }
        try {
            Object pluginInstance = pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (OBJECT)pluginInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new LoadingException(exception);
        }
    }

    public static class LoadingException
    extends Exception {
        public LoadingException(String message) {
            super(message);
        }

        public LoadingException(Throwable cause) {
            super(cause);
        }
    }

    public static class WrongFileFormatException
    extends LoadingException {
        public WrongFileFormatException(String message) {
            super(message);
        }

        public WrongFileFormatException(Throwable cause) {
            super(cause);
        }
    }
}

