/*
 * Decompiled with CFR 0.152.
 */
package pluginloader.load;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import pluginloader.load.PluginFileManager;

public class PluginCompiler {
    public static byte[] compile(String pluginName, String sourceCode) throws CompilationFailedException {
        List<String> options;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaByteObject javaByteObject = new JavaByteObject(pluginName);
        PluginFileManager pluginFileManager = new PluginFileManager(compiler.getStandardFileManager(diagnostics, null, null), javaByteObject);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, pluginFileManager, diagnostics, options = Collections.emptyList(), null, () -> {
            JavaStringObject javaFileObject = new JavaStringObject(pluginName, sourceCode);
            return Collections.singletonList(javaFileObject).iterator();
        });
        boolean compilationSuccessful = compilationTask.call();
        if (!compilationSuccessful) {
            String message = diagnostics.getDiagnostics().stream().map(new Function<Diagnostic<? extends JavaFileObject>, String>(){

                @Override
                public String apply(Diagnostic<? extends JavaFileObject> diagnostic) {
                    return diagnostic.toString();
                }
            }).collect(Collectors.joining());
            throw new CompilationFailedException(String.format("Failed to compile class '%s':\n%s", pluginName, message), sourceCode);
        }
        return javaByteObject.getBytes();
    }

    private static class JavaByteObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public JavaByteObject(String name) {
            super(URI.create(String.format("bytes:///%s%s", name, name.replaceAll("\\.", "/"))), JavaFileObject.Kind.CLASS);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.outputStream;
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }
    }

    public static class CompilationFailedException
    extends Exception {
        private final String code;

        public CompilationFailedException(String message, String code) {
            super(message);
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    private static class JavaStringObject
    extends SimpleJavaFileObject {
        private final String code;

        public JavaStringObject(String pluginName, String code) {
            super(URI.create(String.format("string:///%s%s", pluginName.replace('.', '/'), JavaFileObject.Kind.SOURCE.extension)), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

