/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.siegeinsights.r6tab.api.impl;

import com.gitlab.siegeinsights.r6tab.api.R6TabApiException;
import com.gitlab.siegeinsights.r6tab.api.R6TabRequestTimeoutException;
import com.gitlab.siegeinsights.r6tab.api.entity.player.Player;
import com.gitlab.siegeinsights.r6tab.api.entity.search.Platform;
import com.gitlab.siegeinsights.r6tab.api.entity.search.SearchResultWrapper;
import com.gitlab.siegeinsights.r6tab.api.impl.Mapper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R6TabApiService {
    private Logger log = LoggerFactory.getLogger(R6TabApiService.class);
    private OkHttpClient httpClient;
    private String baseUrl;
    private Mapper mapper = new Mapper();

    public R6TabApiService() {
        this(30000L);
    }

    public R6TabApiService(String baseUrl, long timeout) {
        this(timeout);
        this.baseUrl = baseUrl;
    }

    public R6TabApiService(long timeout) {
        this.httpClient = new OkHttpClient.Builder().connectTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).callTimeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    public R6TabApiService(String baseUrl) {
        this();
        this.baseUrl = baseUrl;
    }

    public Player getPlayerByUuid(String uuid) throws R6TabApiException {
        if (uuid == null || uuid.isEmpty()) {
            throw new R6TabApiException("UUID cannot be null or empty");
        }
        String result = this.get(this.baseUrl + "player.php" + "?p_id=" + uuid);
        return this.mapper.getPlayerFromJson(result);
    }

    public SearchResultWrapper searchPlayer(String playerName, Platform platform) throws R6TabApiException {
        if (playerName == null) {
            throw new R6TabApiException("playerName cannot be empty");
        }
        if (platform == null) {
            throw new R6TabApiException("platform cannot be null");
        }
        try {
            String response;
            SearchResultWrapper resultWrapper;
            StringBuilder requestUrlBuilder = new StringBuilder().append(this.baseUrl).append("search.php").append("?search=").append(URLEncoder.encode(playerName, "UTF-8"));
            if (platform != null) {
                requestUrlBuilder.append("&platform=").append(platform.getName());
            }
            if (!(resultWrapper = this.mapper.getSearchResultsFromJson(response = this.get(requestUrlBuilder.toString()))).isValidResultsCount()) {
                throw new R6TabApiException("Result count does not match actual resultWrapper that has been returned");
            }
            return resultWrapper;
        }
        catch (UnsupportedEncodingException e) {
            throw new R6TabApiException("Encoding error: " + e.getMessage());
        }
    }

    public String get(String url) throws R6TabApiException {
        this.log.debug("Executing web request: " + url);
        Request request = new Request.Builder().url(url).get().build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.code() != 200) {
                this.log.error("Request returned with status code " + response.code());
                if (response.body() != null && response.body().string().contains("cloudflare")) {
                    this.log.error("Request was properly blocked by cloudflare. Did you spam / abuse the API?");
                    throw new R6TabApiException("Cloudflare CDN seems to block our requests. Did you spam / abuse the API?");
                }
                this.log.error("Return code does not match 200. Received: " + response.code());
                throw new R6TabApiException("Request did not return with code 200 or body is empty. Received status code: " + response.code());
            }
            String responseString = response.body() != null ? response.body().string() : null;
            this.log.trace("Response from API is : " + responseString.length() + " bytes long");
            return responseString;
        }
        catch (SocketTimeoutException e) {
            this.log.debug("API call timed out: " + e.getMessage(), (Throwable)e);
            throw new R6TabRequestTimeoutException("API request timed out");
        }
        catch (InterruptedIOException e) {
            this.log.debug("API call timed out (interrupted): " + e.getMessage(), (Throwable)e);
            throw new R6TabRequestTimeoutException("API request timed out (interrupted)");
        }
        catch (IOException e) {
            this.log.error("API call failed with an IOException: " + e.getMessage(), (Throwable)e);
            throw new R6TabApiException("Call failed with an IOException");
        }
    }
}

