/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.siegeinsights.r6tab.api.entity.player;

import com.gitlab.siegeinsights.r6tab.api.entity.player.Match;
import com.gitlab.siegeinsights.r6tab.api.entity.player.R6TabRank;
import com.gitlab.siegeinsights.r6tab.api.entity.player.Social;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class Player
implements Serializable {
    @SerializedName(value="playerfound")
    private boolean playerFound;
    @SerializedName(value="social")
    private Social social;
    @SerializedName(value="matches")
    private List<Match> matches;
    @SerializedName(value="p_id")
    private String playerId;
    @SerializedName(value="p_name")
    private String name;
    @SerializedName(value="p_user")
    private String user;
    @SerializedName(value="p_level")
    private int level;
    @SerializedName(value="p_pvtrank")
    private int pvtRank;
    @SerializedName(value="utime")
    private String uTime;
    @SerializedName(value="kd")
    private float kd;
    @SerializedName(value="p_visitors")
    private int visitors;
    @SerializedName(value="p_currentrank")
    private Integer currentRankId;
    @SerializedName(value="p_currentmmr")
    private int currentMmr;
    @SerializedName(value="p_maxrank")
    private Integer maxRankId;
    @SerializedName(value="p_maxmmr")
    private int maxMmr;
    @SerializedName(value="p_skillrating")
    private int skillRating;
    @SerializedName(value="p_headshotacc")
    private int headshotAccuraccy;

    public boolean isPlayerFound() {
        return this.playerFound;
    }

    public Social getSocial() {
        return this.social;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public String getPlayerIdAsString() {
        return this.playerId;
    }

    public UUID getPlayerId() {
        if (this.playerId == null) {
            return null;
        }
        return UUID.fromString(this.playerId);
    }

    public String getName() {
        return this.name;
    }

    public String getUserAsString() {
        return this.user;
    }

    public UUID getUser() {
        if (this.user == null) {
            return null;
        }
        return UUID.fromString(this.user);
    }

    public int getLevel() {
        return this.level;
    }

    public int getPvtRank() {
        return this.pvtRank;
    }

    public String getuTime() {
        return this.uTime;
    }

    public float getKd() {
        return this.kd;
    }

    public int getVisitors() {
        return this.visitors;
    }

    public Integer getCurrentRankId() {
        return this.currentRankId;
    }

    public R6TabRank getCurrentRank() {
        return R6TabRank.getRankById(this.getCurrentRankId());
    }

    public int getCurrentMmr() {
        return this.currentMmr;
    }

    public Integer getMaxRankId() {
        return this.maxRankId;
    }

    public R6TabRank getMaxRank() {
        return R6TabRank.getRankById(this.getMaxRankId());
    }

    public int getMaxMmr() {
        return this.maxMmr;
    }

    public int getSkillRating() {
        return this.skillRating;
    }

    public int getHeadshotAccuraccy() {
        return this.headshotAccuraccy;
    }

    public String toString() {
        return "PlayerName: " + this.getName() + " UUID: " + this.getPlayerIdAsString() + " Rank: " + this.getCurrentRank() + " MaxRank: " + this.getMaxRank();
    }
}

