/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.siegeinsights.r6tab.api.impl;

import com.gitlab.siegeinsights.r6tab.api.Constants;
import com.gitlab.siegeinsights.r6tab.api.R6TabApi;
import com.gitlab.siegeinsights.r6tab.api.R6TabApiException;
import com.gitlab.siegeinsights.r6tab.api.R6TabPlayerNotFoundException;
import com.gitlab.siegeinsights.r6tab.api.entity.leaderboard.LeaderBoardEntry;
import com.gitlab.siegeinsights.r6tab.api.entity.player.Player;
import com.gitlab.siegeinsights.r6tab.api.entity.search.Platform;
import com.gitlab.siegeinsights.r6tab.api.entity.search.SearchResult;
import com.gitlab.siegeinsights.r6tab.api.entity.search.SearchResultWrapper;
import com.gitlab.siegeinsights.r6tab.api.impl.R6TabApiService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.UUID;

public class R6TabApiImpl
implements R6TabApi {
    private R6TabApiService service = new R6TabApiService("https://r6tab.com/api/");

    @Override
    public Player getPlayerByUUID(UUID uuid) throws R6TabApiException, R6TabPlayerNotFoundException {
        return this.getPlayerByUUID(uuid, false);
    }

    @Override
    public Player getPlayerByUUID(UUID uuid, boolean pushUpdate) throws R6TabApiException, R6TabPlayerNotFoundException {
        Player p;
        if (pushUpdate) {
            this.service.pushPlayerUpdate(uuid);
        }
        if (!(p = this.service.getPlayerByUuid(uuid)).isPlayerFound()) {
            throw new R6TabPlayerNotFoundException("Player with uuid: " + uuid + " was not found");
        }
        return p;
    }

    @Override
    public SearchResultWrapper searchPlayer(String playerName, Platform platform) throws R6TabApiException {
        return this.service.searchPlayer(playerName, platform);
    }

    public void pushPlayerUpdate(UUID playerUuid) throws R6TabApiException {
        this.service.pushPlayerUpdate(playerUuid);
    }

    @Override
    public List<LeaderBoardEntry> getLeaderBoard(Platform platform, Constants.SortRegion sortRegion) throws R6TabApiException {
        return this.service.getLeaderBoard(platform, sortRegion);
    }

    @Override
    public BufferedImage getUserAvatar(UUID userUuid) throws R6TabApiException {
        return this.service.getAvatar(userUuid);
    }

    @Override
    public File getUserAvatarFile(UUID userUuid) throws R6TabApiException {
        return this.service.getAvatarFile(userUuid);
    }

    @Override
    public BufferedImage getUserAvatar(Player player) throws R6TabApiException {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        return this.service.getAvatar(player.getUser());
    }

    @Override
    public BufferedImage getUserAvatar(SearchResult searchResult) throws R6TabApiException {
        if (searchResult == null) {
            throw new IllegalArgumentException("searchResult cannot be null");
        }
        return this.service.getAvatar(searchResult.getUserUuid());
    }
}

