/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.siegeinsights.r6tab.api.impl;

import com.gitlab.siegeinsights.r6tab.api.Constants;
import com.gitlab.siegeinsights.r6tab.api.R6TabApiException;
import com.gitlab.siegeinsights.r6tab.api.R6TabRequestTimeoutException;
import com.gitlab.siegeinsights.r6tab.api.entity.leaderboard.LeaderBoardEntry;
import com.gitlab.siegeinsights.r6tab.api.entity.player.Player;
import com.gitlab.siegeinsights.r6tab.api.entity.search.Platform;
import com.gitlab.siegeinsights.r6tab.api.entity.search.SearchResultWrapper;
import com.gitlab.siegeinsights.r6tab.api.impl.Mapper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R6TabApiService {
    private Logger log = LoggerFactory.getLogger(R6TabApiService.class);
    private OkHttpClient httpClient;
    private String baseUrl;
    private Mapper mapper = new Mapper();

    public R6TabApiService() {
        this(30000L);
    }

    public R6TabApiService(String baseUrl, long timeout) {
        this(timeout);
        this.baseUrl = baseUrl;
    }

    public R6TabApiService(long timeout) {
        this.httpClient = new OkHttpClient.Builder().connectTimeout(timeout, TimeUnit.MILLISECONDS).writeTimeout(timeout, TimeUnit.MILLISECONDS).callTimeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    public R6TabApiService(String baseUrl) {
        this();
        this.baseUrl = baseUrl;
    }

    public Player getPlayerByUuid(UUID playerUuid) throws R6TabApiException {
        if (playerUuid == null) {
            throw new R6TabApiException("UUID cannot be null or empty");
        }
        String result = this.get(this.baseUrl + "player.php" + "?p_id=" + playerUuid);
        return this.mapper.getPlayerFromJson(result);
    }

    public void pushPlayerUpdate(UUID playerUuid) throws R6TabApiException {
        if (playerUuid == null) {
            throw new R6TabApiException("UUID cannot be null or empty");
        }
        this.log.trace("Pushing player update for UUID: " + playerUuid + " ...");
        this.get("https://r6tab.com/mainpage.php?page=" + playerUuid + "&updatenow=true");
    }

    public SearchResultWrapper searchPlayer(String playerName, Platform platform) throws R6TabApiException {
        if (playerName == null) {
            throw new R6TabApiException("playerName cannot be empty");
        }
        if (platform == null) {
            throw new R6TabApiException("platform cannot be null");
        }
        try {
            StringBuilder requestUrlBuilder = new StringBuilder().append(this.baseUrl).append("search.php").append("?search=").append(URLEncoder.encode(playerName, "UTF-8")).append("&platform=").append(platform.getName());
            String response = this.get(requestUrlBuilder.toString());
            SearchResultWrapper resultWrapper = this.mapper.getSearchResultsFromJson(response);
            if (!resultWrapper.isValidResultsCount()) {
                throw new R6TabApiException("Result count does not match actual resultWrapper that has been returned");
            }
            return resultWrapper;
        }
        catch (UnsupportedEncodingException e) {
            throw new R6TabApiException("Encoding error: " + e.getMessage());
        }
    }

    public List<LeaderBoardEntry> getLeaderBoard(Platform platform, Constants.SortRegion sort) throws R6TabApiException {
        if (platform == null) {
            throw new R6TabApiException("Platform cannot be null or empty");
        }
        if (sort == null) {
            throw new R6TabApiException("SortRegion cannot be null or empty");
        }
        String result = this.get(this.baseUrl + "leaderboards.php" + "?sortplatform=" + platform.getName() + "&sortregion=" + sort.getSortBy());
        return this.mapper.getLeaderBoardResultFromJson(result);
    }

    public File getAvatarFile(UUID userUuid) throws R6TabApiException {
        File file;
        Response response;
        String requestUrl = "https://ubisoft-avatars.akamaized.net/" + userUuid.toString() + "/default_146_146.png";
        Request imageDownload = new Request.Builder().url(requestUrl).get().build();
        try {
            response = this.httpClient.newCall(imageDownload).execute();
        }
        catch (IOException e) {
            this.log.error("Unable to download avatar: " + e.getMessage(), (Throwable)e);
            throw new R6TabApiException("Avatar download failed: " + e.getMessage());
        }
        if (!response.isSuccessful()) {
            throw new R6TabApiException("Failed to download file: " + response);
        }
        File tmpFile = File.createTempFile("r6tab_avatar_", ".png");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        try {
            if (response.body() == null) {
                throw new R6TabApiException("Response is null");
            }
            fos.write(response.body().bytes());
            this.log.debug("Downloaded avatar from " + requestUrl + " and saved as: " + tmpFile.getAbsolutePath());
            file = tmpFile;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    this.log.error("Unable to create temp file: " + e.getMessage(), (Throwable)e);
                    throw new R6TabApiException("Unable to create temp file: " + e.getMessage());
                }
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new R6TabApiException(e.getMessage());
            }
        }
        fos.close();
        return file;
    }

    public BufferedImage getAvatar(UUID userUuid) throws R6TabApiException {
        File tempFile = this.getAvatarFile(userUuid);
        try {
            return ImageIO.read(tempFile);
        }
        catch (IOException e) {
            this.log.error("Unable to download avatar: " + e.getMessage(), (Throwable)e);
            throw new R6TabApiException("Unable to download avatar: " + e.getMessage());
        }
    }

    public String get(String url) throws R6TabApiException {
        this.log.debug("Executing web request: " + url);
        Request request = new Request.Builder().url(url).get().build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            if (response.code() != 200) {
                this.log.error("Request returned with status code " + response.code());
                if (response.body() != null && response.body().string().contains("cloudflare")) {
                    this.log.error("Request was properly blocked by cloudflare. Did you spam / abuse the API?");
                    throw new R6TabApiException("Cloudflare CDN seems to block our requests. Did you spam / abuse the API?");
                }
                this.log.error("Return code does not match 200. Received: " + response.code());
                throw new R6TabApiException("Request did not return with code 200 or body is empty. Received status code: " + response.code());
            }
            String responseString = response.body() != null ? response.body().string() : null;
            this.log.trace("Response from API is : " + responseString.length() + " bytes long");
            return responseString;
        }
        catch (SocketTimeoutException e) {
            this.log.debug("API call timed out: " + e.getMessage(), (Throwable)e);
            throw new R6TabRequestTimeoutException("API request timed out");
        }
        catch (InterruptedIOException e) {
            this.log.debug("API call timed out (interrupted): " + e.getMessage(), (Throwable)e);
            throw new R6TabRequestTimeoutException("API request timed out (interrupted)");
        }
        catch (IOException e) {
            this.log.error("API call failed with an IOException: " + e.getMessage(), (Throwable)e);
            throw new R6TabApiException("Call failed with an IOException");
        }
    }
}

