/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.gdc.ErrorStructure;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.ISOZonedDateTime;
import com.gooddata.sdk.common.util.Validate;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="executionDetail")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessExecutionDetail {
    private static final String LOG_LINK = "log";
    private static final String SELF_LINK = "self";
    private static final String EXECUTION_LINK = "poll";
    private static final String STATUS_OK = "OK";
    private final String status;
    @ISOZonedDateTime
    private final ZonedDateTime created;
    @ISOZonedDateTime
    private final ZonedDateTime started;
    @ISOZonedDateTime
    private final ZonedDateTime updated;
    @ISOZonedDateTime
    private final ZonedDateTime finished;
    private final ErrorStructure error;
    private final Map<String, String> links;

    @JsonCreator
    private ProcessExecutionDetail(@JsonProperty(value="status") String status, @JsonProperty(value="created") ZonedDateTime created, @JsonProperty(value="started") ZonedDateTime started, @JsonProperty(value="updated") ZonedDateTime updated, @JsonProperty(value="finished") ZonedDateTime finished, @JsonProperty(value="error") ErrorStructure error, @JsonProperty(value="links") Map<String, String> links) {
        this.status = (String)Validate.notEmpty((CharSequence)status, (String)"status");
        this.created = (ZonedDateTime)Validate.notNull((Object)created, (String)"created");
        this.started = started;
        this.updated = updated;
        this.finished = finished;
        this.error = error;
        this.links = links;
    }

    public String getStatus() {
        return this.status;
    }

    public ZonedDateTime getCreated() {
        return this.created;
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    public ZonedDateTime getFinished() {
        return this.finished;
    }

    public ErrorStructure getError() {
        return this.error;
    }

    @JsonIgnore
    public String getLogUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(LOG_LINK);
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getExecutionUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(EXECUTION_LINK);
    }

    @JsonIgnore
    public boolean isSuccess() {
        return STATUS_OK.equals(this.status);
    }

    public static URI uriFromExecutionUri(URI executionUri) {
        return URI.create(executionUri.toString() + "/detail");
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

