/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.dashboard.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.md.dashboard.filter.DashboardFilter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="dateFilter")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashboardDateFilter
implements DashboardFilter {
    public static final String RELATIVE_FILTER_TYPE = "relative";
    public static final String ABSOLUTE_FILTER_TYPE = "absolute";
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final String ABSOLUTE_DATE_FILTER_GRANULARITY = "GDC.time.date";
    static final String NAME = "dateFilter";
    private final String from;
    private final String to;
    private final String granularity;
    private final String dataset;
    private final String type;

    @JsonCreator
    private DashboardDateFilter(@JsonProperty(value="from") String from, @JsonProperty(value="to") String to, @JsonProperty(value="granularity") String granularity, @JsonProperty(value="dataSet") String dataset, @JsonProperty(value="type") String type) {
        this.from = from;
        this.to = to;
        this.granularity = granularity;
        this.dataset = dataset;
        this.type = type;
    }

    @JsonIgnore
    public static DashboardDateFilter relativeDateFilter(int from, int to, String granularity, String datasetUri) {
        return new DashboardDateFilter(Integer.toString(from), Integer.toString(to), (String)Validate.notEmpty((CharSequence)granularity, (String)"granularity"), datasetUri, RELATIVE_FILTER_TYPE);
    }

    @JsonIgnore
    public static DashboardDateFilter absoluteDateFilter(LocalDate from, LocalDate to, String datasetUri) {
        return new DashboardDateFilter(((LocalDate)Validate.notNull((Object)from, (String)"from")).format(DATE_FORMAT), ((LocalDate)Validate.notNull((Object)to, (String)"to")).format(DATE_FORMAT), ABSOLUTE_DATE_FILTER_GRANULARITY, datasetUri, ABSOLUTE_FILTER_TYPE);
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public String getDataSet() {
        return this.dataset;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return GoodDataToStringBuilder.toString((Object)this);
    }
}

