/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.visualization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.model.executeafm.afm.LocallyIdentifiable;
import com.gooddata.sdk.model.md.visualization.BucketItem;
import com.gooddata.sdk.model.md.visualization.VisualizationAttribute;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Bucket
implements Serializable,
LocallyIdentifiable {
    private static final long serialVersionUID = -7718720886547680021L;
    private final String localIdentifier;
    private final List<BucketItem> items;

    @JsonCreator
    public Bucket(@JsonProperty(value="localIdentifier") String localIdentifier, @JsonProperty(value="items") List<BucketItem> items) {
        this.localIdentifier = localIdentifier;
        this.items = items;
    }

    @Override
    public String getLocalIdentifier() {
        return this.localIdentifier;
    }

    public List<BucketItem> getItems() {
        return this.items;
    }

    @JsonIgnore
    VisualizationAttribute getOnlyAttribute() {
        BucketItem item;
        if (this.getItems() != null && this.getItems().size() == 1 && (item = this.getItems().iterator().next()) instanceof VisualizationAttribute) {
            return (VisualizationAttribute)item;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        return Objects.equals(this.localIdentifier, bucket.localIdentifier) && Objects.equals(this.items, bucket.items);
    }

    public int hashCode() {
        return Objects.hash(this.localIdentifier, this.items);
    }
}

