/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.gooddata.sdk.common.util.BooleanDeserializer;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.project.ProjectValidationResult;
import com.gooddata.sdk.model.project.ProjectValidationResultItem;
import java.util.LinkedList;
import java.util.List;

@JsonTypeName(value="projectValidateResult")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectValidationResults {
    private final boolean error;
    private final boolean fatalError;
    private final boolean warning;
    private final List<ProjectValidationResult> results = new LinkedList<ProjectValidationResult>();

    @JsonCreator
    private ProjectValidationResults(@JsonProperty(value="error_found") @JsonDeserialize(using=BooleanDeserializer.class) boolean error, @JsonProperty(value="fatal_error_found") @JsonDeserialize(using=BooleanDeserializer.class) boolean fatalError, @JsonProperty(value="results") List<ProjectValidationResultItem> resultItems) {
        this.error = error;
        this.fatalError = fatalError;
        boolean hasWarning = false;
        for (ProjectValidationResultItem resultItem : resultItems) {
            List<ProjectValidationResult> itemResults = resultItem.getLogs();
            if (itemResults == null) continue;
            for (ProjectValidationResult log : itemResults) {
                log.setValidation(resultItem.getValidation());
                this.results.add(log);
                hasWarning = hasWarning || log.isWarning();
            }
        }
        this.warning = hasWarning;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFatalError() {
        return this.fatalError;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public boolean isValid() {
        return !this.error && !this.fatalError && !this.warning;
    }

    public List<ProjectValidationResult> getResults() {
        return this.results;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

