/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.export.ExportFormat;
import com.gooddata.sdk.model.md.AbstractObj;
import com.gooddata.sdk.model.md.Attachment;
import com.gooddata.sdk.model.md.DashboardAttachment;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Queryable;
import com.gooddata.sdk.model.md.ReportAttachment;
import com.gooddata.sdk.model.md.ScheduledMailWhen;
import com.gooddata.sdk.model.md.Updatable;
import com.gooddata.sdk.model.md.report.ReportDefinition;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="scheduledMail")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduledMail
extends AbstractObj
implements Queryable,
Updatable {
    private static final long serialVersionUID = -4433891105896592638L;
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    ScheduledMail(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    private ScheduledMail(String title, String summary, Set<String> tags, boolean deprecated, String recurrency, LocalDate startDate, String timeZone, Collection<String> toAddresses, Collection<String> bccAddresses, String subject, String body, List<Attachment> attachments) {
        super(new Meta(null, null, null, null, summary, title, null, tags, null, null, deprecated, null, false, false, null, null));
        Validate.notNull(toAddresses, (String)"toAddresses");
        Validate.notNull((Object)subject, (String)"subject");
        Validate.notNull((Object)body, (String)"body");
        Validate.notNull(attachments, (String)"attachments");
        this.content = new Content(new ScheduledMailWhen(recurrency, startDate, timeZone), toAddresses, bccAddresses, subject, body, attachments);
    }

    public ScheduledMail(String title, String summary) {
        super(new Meta(null, null, null, null, summary, title, null, Collections.emptySet(), null, null, false, null, false, false, null, null));
        this.content = new Content();
    }

    public ScheduledMail(String title, String summary, String recurrency, LocalDate startDate, String timeZone, Collection<String> toAddresses, Collection<String> bccAddresses, String subject, String body, List<Attachment> attachments) {
        this(title, summary, Collections.emptySet(), false, recurrency, startDate, timeZone, toAddresses, bccAddresses, subject, body, attachments);
    }

    @JsonIgnore
    public ScheduledMailWhen getWhen() {
        return this.content.getScheduledMailWhen();
    }

    @JsonIgnore
    public Collection<String> getToAddresses() {
        return this.content.getToAddresses();
    }

    @JsonIgnore
    public Collection<String> getBccAddresses() {
        return this.content.getBccAddresses();
    }

    @JsonIgnore
    public String getSubject() {
        return this.content.getSubject();
    }

    @JsonIgnore
    public String getBody() {
        return this.content.getBody();
    }

    @JsonIgnore
    public Collection<? extends Attachment> getAttachments() {
        return this.content.getAttachments();
    }

    public ScheduledMail setRecurrency(String recurrency) {
        this.content.getScheduledMailWhen().setRecurrency(recurrency);
        return this;
    }

    public ScheduledMail setStartDate(LocalDate startDate) {
        this.content.getScheduledMailWhen().setStartDate(startDate);
        return this;
    }

    public ScheduledMail setTimeZone(String timeZone) {
        this.content.getScheduledMailWhen().setTimeZone(timeZone);
        return this;
    }

    public ScheduledMail setTo(Collection<String> toAddresses) {
        this.content.setToAddress(toAddresses);
        return this;
    }

    public ScheduledMail setBcc(Collection<String> bccAddresses) {
        this.content.setBccAddress(bccAddresses);
        return this;
    }

    public ScheduledMail setSubject(String subject) {
        this.content.setSubject(subject);
        return this;
    }

    public ScheduledMail setBody(String body) {
        this.content.setBody(body);
        return this;
    }

    public ScheduledMail setAttachments(List<Attachment> attachments) {
        this.content.setAttachments(attachments);
        return this;
    }

    public ScheduledMail addToAddress(String toAdd) {
        this.content.getToAddresses().add(toAdd);
        return this;
    }

    public ScheduledMail addBccAddress(String bccAdd) {
        this.content.getBccAddresses().add(bccAdd);
        return this;
    }

    public ScheduledMail addReportAttachment(ReportDefinition reportDefinition, Map<String, String> exportOptions, String ... formats) {
        Validate.notNull((Object)formats, (String)"formats");
        ReportAttachment ra = new ReportAttachment(reportDefinition.getUri(), exportOptions, formats);
        this.content.getAttachments().add(ra);
        return this;
    }

    public ScheduledMail addReportAttachment(ReportDefinition reportDefinition, Map<String, String> exportOptions, ExportFormat ... formats) {
        return this.addReportAttachment(reportDefinition, exportOptions, ExportFormat.arrayToStringArray(formats));
    }

    public ScheduledMail addDashboardAttachment(String uri, Integer allTabs, String executionContext, String ... tabs) {
        Validate.notNull((Object)tabs, (String)"tabs");
        DashboardAttachment da = new DashboardAttachment(uri, allTabs, executionContext, tabs);
        this.content.getAttachments().add(da);
        return this;
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    private static class Content
    implements Serializable {
        private static final long serialVersionUID = -6676890634279968527L;
        @JsonProperty(value="when")
        private ScheduledMailWhen scheduledMailWhen;
        @JsonProperty(value="to")
        private Collection<String> toAddress;
        @JsonProperty(value="bcc")
        private Collection<String> bccAddress;
        private String subject;
        private String body;
        private Collection<Attachment> attachments;

        @JsonCreator
        public Content(@JsonProperty(value="when") ScheduledMailWhen scheduledMailWhen, @JsonProperty(value="to") Collection<String> toAddress, @JsonProperty(value="bcc") Collection<String> bccAddress, @JsonProperty(value="subject") String subject, @JsonProperty(value="body") String body, @JsonProperty(value="attachments") Collection<Attachment> attachments) {
            this.scheduledMailWhen = scheduledMailWhen;
            this.toAddress = toAddress;
            this.bccAddress = bccAddress;
            this.subject = subject;
            this.body = body;
            this.attachments = attachments;
        }

        public Content() {
            this.scheduledMailWhen = new ScheduledMailWhen();
            this.toAddress = new ArrayList<String>();
            this.bccAddress = new ArrayList<String>();
            this.attachments = new ArrayList<Attachment>();
        }

        @JsonIgnore
        public ScheduledMailWhen getScheduledMailWhen() {
            return this.scheduledMailWhen;
        }

        @JsonIgnore
        public Collection<String> getToAddresses() {
            return this.toAddress;
        }

        @JsonIgnore
        public Collection<String> getBccAddresses() {
            return this.bccAddress;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getBody() {
            return this.body;
        }

        public Collection<Attachment> getAttachments() {
            return this.attachments;
        }

        public void setScheduledMailWhen(ScheduledMailWhen scheduledMailWhen) {
            this.scheduledMailWhen = scheduledMailWhen;
        }

        public void setToAddress(Collection<String> toAddress) {
            this.toAddress = toAddress;
        }

        public void setBccAddress(Collection<String> bccAddress) {
            this.bccAddress = bccAddress;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setAttachments(Collection<Attachment> attachments) {
            this.attachments = attachments;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

