/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.ISOZonedDateTime;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.connector.Status;
import com.gooddata.sdk.model.util.UriHelper;
import java.time.ZonedDateTime;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IntegrationProcessStatus {
    public static final String URI = "/gdc/projects/{project}/connectors/{connector}/integration/processes/{process}";
    private static final String SELF_LINK = "self";
    private final Status status;
    @ISOZonedDateTime
    private final ZonedDateTime started;
    @ISOZonedDateTime
    private final ZonedDateTime finished;
    private final Map<String, String> links;

    @JsonCreator
    protected IntegrationProcessStatus(@JsonProperty(value="status") Status status, @JsonProperty(value="started") ZonedDateTime started, @JsonProperty(value="finished") ZonedDateTime finished, @JsonProperty(value="links") Map<String, String> links) {
        this.status = status;
        this.started = started;
        this.finished = finished;
        this.links = links;
    }

    public Status getStatus() {
        return this.status;
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public ZonedDateTime getFinished() {
        return this.finished;
    }

    @JsonIgnore
    public boolean isFinished() {
        return this.status != null && this.status.isFinished();
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.status != null && this.status.isFailed();
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getId() {
        return UriHelper.getLastUriPart(this.getUri());
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

