/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.executeafm.IdentifierObjQualifier;
import com.gooddata.sdk.model.executeafm.ObjQualifier;
import com.gooddata.sdk.model.executeafm.Qualifier;
import com.gooddata.sdk.model.executeafm.afm.ObjQualifierConverter;
import com.gooddata.sdk.model.executeafm.afm.filter.CompatibilityFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.ExtendedFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.RankingFilterOperator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonRootName(value="rankingFilter")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RankingFilter
implements ExtendedFilter,
CompatibilityFilter,
Serializable {
    public static final String NAME = "rankingFilter";
    private static final long serialVersionUID = 2642298346540031612L;
    private final List<Qualifier> measures;
    private final List<Qualifier> attributes;
    private final String operator;
    private final Integer value;

    @JsonCreator
    public RankingFilter(@JsonProperty(value="measures") List<Qualifier> measures, @JsonProperty(value="attributes") List<Qualifier> attributes, @JsonProperty(value="operator") String operator, @JsonProperty(value="value") Integer value) {
        this.measures = (List)Validate.notNull(measures, (String)"measures must not be null!");
        this.attributes = attributes;
        this.operator = (String)Validate.notNull((Object)operator, (String)"operator must not be null!");
        this.value = (Integer)Validate.notNull((Object)value, (String)"value must not be null!");
    }

    public RankingFilter(List<Qualifier> measures, List<Qualifier> attributes, RankingFilterOperator operator, Integer value) {
        this(measures, attributes, ((RankingFilterOperator)((Object)Validate.notNull((Object)((Object)operator), (String)"operator must not be null!"))).name(), value);
    }

    @JsonIgnore
    public Collection<ObjQualifier> getObjQualifiers() {
        return Stream.concat(this.measures.stream(), this.attributes == null ? Stream.empty() : this.attributes.stream()).filter(ObjQualifier.class::isInstance).map(ObjQualifier.class::cast).collect(Collectors.toSet());
    }

    public RankingFilter withObjUriQualifiers(ObjQualifierConverter objQualifierConverter) {
        Validate.notNull((Object)objQualifierConverter, (String)"objQualifierConverter");
        return new RankingFilter(this.translateIdentifierQualifiers(this.measures, objQualifierConverter), this.attributes == null ? null : this.translateIdentifierQualifiers(this.attributes, objQualifierConverter), this.operator, this.value);
    }

    private List<Qualifier> translateIdentifierQualifiers(List<Qualifier> qualifiers, ObjQualifierConverter objQualifierConverter) {
        return qualifiers.stream().map(qualifier -> this.translateIdentifierQualifier((Qualifier)qualifier, objQualifierConverter)).collect(Collectors.toList());
    }

    private Qualifier translateIdentifierQualifier(Qualifier qualifier, ObjQualifierConverter objQualifierConverter) {
        if (qualifier instanceof IdentifierObjQualifier) {
            IdentifierObjQualifier identifierQualifierToConvert = (IdentifierObjQualifier)qualifier;
            return objQualifierConverter.convertToUriQualifier(identifierQualifierToConvert).orElseThrow(() -> RankingFilter.buildExceptionForFailedConversion(identifierQualifierToConvert));
        }
        return qualifier;
    }

    private static IllegalArgumentException buildExceptionForFailedConversion(IdentifierObjQualifier qualifierFailedToConvert) {
        return new IllegalArgumentException(String.format("Supplied converter does not provide conversion for '%s'!", qualifierFailedToConvert));
    }

    public List<Qualifier> getMeasures() {
        return this.measures;
    }

    public List<Qualifier> getAttributes() {
        return this.attributes;
    }

    @JsonIgnore
    public RankingFilterOperator getOperator() {
        return RankingFilterOperator.of(this.operator);
    }

    @JsonProperty(value="operator")
    public String getOperatorAsString() {
        return this.operator;
    }

    public Integer getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankingFilter that = (RankingFilter)o;
        return Objects.equals(this.measures, that.measures) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.operator, that.operator) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.measures, this.attributes, this.operator, this.value);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

