/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.result;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import java.util.Collections;
import java.util.List;

public class Warning {
    private final String warningCode;
    private final String message;
    private final List<Object> parameters;

    public Warning(String warningCode, String message) {
        this(warningCode, message, Collections.emptyList());
    }

    @JsonCreator
    public Warning(@JsonProperty(value="warningCode") String warningCode, @JsonProperty(value="message") String message, @JsonProperty(value="parameters") List<Object> parameters) {
        this.warningCode = (String)Validate.notEmpty((CharSequence)warningCode, (String)"warningCode");
        this.message = (String)Validate.notEmpty((CharSequence)message, (String)"message");
        this.parameters = (List)Validate.notNull(parameters, (String)"parameters");
    }

    public String getWarningCode() {
        return this.warningCode;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        if (this.warningCode != null ? !this.warningCode.equals(warning.warningCode) : warning.warningCode != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(warning.message) : warning.message != null) {
            return false;
        }
        return this.parameters != null ? this.parameters.equals(warning.parameters) : warning.parameters == null;
    }

    public int hashCode() {
        int result = this.warningCode != null ? this.warningCode.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

