/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.md.Meta;

@JsonTypeName(value="invitation")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Invitation {
    private final InvitationContent content;
    private final Meta meta;

    private Invitation(InvitationContent content, Meta meta) {
        this.meta = meta;
        this.content = content;
    }

    public Invitation(String email) {
        this(new InvitationContent(email), null);
    }

    @JsonProperty
    private InvitationContent getContent() {
        return this.content;
    }

    public Meta getMeta() {
        return this.meta;
    }

    @JsonIgnore
    public String getEmail() {
        return this.content != null ? this.content.getEmail() : null;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class InvitationContent {
        private final String email;

        private InvitationContent(String email) {
            this.email = (String)Validate.notEmpty((CharSequence)email, (String)"email");
        }

        public String getEmail() {
            return this.email;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

