/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.export;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;

@JsonTypeName(value="clientExport")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClientExport {
    private static final String DASHBOARD_EXPORT_URI = "/dashboard.html#project=%s&dashboard=%s&tab=%s&export=1";
    private final String url;
    private final String name;

    ClientExport(String url, String name) {
        this.url = (String)Validate.notEmpty((CharSequence)url, (String)"url");
        this.name = (String)Validate.notEmpty((CharSequence)name, (String)"name");
    }

    public ClientExport(String goodDataEndpointUri, String projectUri, String dashboardUri, String tabId) {
        this((String)Validate.notEmpty((CharSequence)goodDataEndpointUri, (String)"goodDataEndpointUri") + String.format(DASHBOARD_EXPORT_URI, Validate.notNull((Object)projectUri, (String)"projectUri"), Validate.notNull((Object)dashboardUri, (String)"dashboardUri"), Validate.notNull((Object)tabId, (String)"tabId")), "export.pdf");
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

