/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.project.ProjectValidationResultParam;
import com.gooddata.sdk.model.project.ProjectValidationType;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectValidationResult {
    private final String category;
    private final String level;
    private final String message;
    private final List<ProjectValidationResultParam> params;
    private static final String LEVEL_WARNING = "WARN";
    private static final String LEVEL_ERROR = "ERROR";
    private ProjectValidationType validation;

    @JsonCreator
    private ProjectValidationResult(@JsonProperty(value="ecat") String category, @JsonProperty(value="level") String level, @JsonProperty(value="msg") String message, @JsonProperty(value="pars") List<ProjectValidationResultParam> params) {
        this.category = category;
        this.level = level;
        this.message = message;
        this.params = params;
    }

    public String getCategory() {
        return this.category;
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ProjectValidationResultParam> getParams() {
        return this.params;
    }

    public boolean isError() {
        return LEVEL_ERROR.equals(this.level);
    }

    public ProjectValidationType getValidation() {
        return this.validation;
    }

    void setValidation(ProjectValidationType validation) {
        this.validation = validation;
    }

    public boolean isWarning() {
        return LEVEL_WARNING.equals(this.level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectValidationResult that = (ProjectValidationResult)o;
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(that.level) : that.level != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        return this.validation != null ? this.validation.equals(that.validation) : that.validation == null;
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.validation != null ? this.validation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

