/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.project.Role;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="user")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User {
    public static final String URI = "/gdc/projects/{projectId}/users/{userId}";
    @JsonProperty
    private UserContent content;
    private Links links;

    @JsonCreator
    User(@JsonProperty(value="content") UserContent content, @JsonProperty(value="links") Links links) {
        this.content = content;
        this.links = links;
    }

    public User(Account account, Role ... userRoles) {
        List userRoleUris = Arrays.asList(userRoles).stream().map(e -> e.getUri()).collect(Collectors.toList());
        this.links = new Links(account.getUri());
        this.content = new UserContent("ENABLED", userRoleUris);
    }

    @JsonIgnore
    public String getEmail() {
        return this.content.getEmail();
    }

    @JsonIgnore
    public String getStatus() {
        return this.content.getStatus();
    }

    @JsonIgnore
    public String getLastName() {
        return this.content.getLastName();
    }

    @JsonIgnore
    public List<String> getUserRoles() {
        return this.content.getUserRoles();
    }

    @JsonIgnore
    public String getLogin() {
        return this.content.getLogin();
    }

    @JsonIgnore
    public String getFirstName() {
        return this.content.getFirstName();
    }

    @JsonIgnore
    public String getPhoneNumber() {
        return this.content.getPhoneNumber();
    }

    public Links getLinks() {
        return this.links;
    }

    public void setStatus(String status) {
        this.content.status = status;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Links {
        private String self;

        private Links(@JsonProperty(value="self") String self) {
            this.self = self;
        }

        public String getSelf() {
            return this.self;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class UserContent {
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="firstname")
        private String firstName;
        @JsonProperty(value="userRoles")
        private List<String> userRoles;
        @JsonProperty(value="phonenumber")
        private String phoneNumber;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="lastname")
        private String lastName;
        @JsonProperty(value="login")
        private String login;

        @JsonCreator
        public UserContent(@JsonProperty(value="email") String email, @JsonProperty(value="firstname") String firstName, @JsonProperty(value="userRoles") List<String> userRoles, @JsonProperty(value="phonenumber") String phoneNumber, @JsonProperty(value="status") String status, @JsonProperty(value="lastname") String lastName, @JsonProperty(value="login") String login) {
            this.email = email;
            this.firstName = firstName;
            this.userRoles = userRoles;
            this.phoneNumber = phoneNumber;
            this.status = status;
            this.lastName = lastName;
            this.login = login;
        }

        private UserContent(String status, List<String> userRoles) {
            this.userRoles = userRoles;
            this.status = status;
        }

        public String getEmail() {
            return this.email;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public List<String> getUserRoles() {
            return this.userRoles;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public String getStatus() {
            return this.status;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getLogin() {
            return this.login;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

