/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Optional;

@JsonTypeName(value="reload")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Reload {
    public static final String URL = "/gdc/projects/{project}/connectors/zendesk4/integration/reloads";
    public static final String CHATS_START_TIME_PROPERTY = "chats";
    public static final String AGENT_TIMELINE_START_TIME_PROPERTY = "agentTimeline";
    public static final String STATUS_DO = "DO";
    public static final String STATUS_RUNNING = "RUNNING";
    public static final String STATUS_FINISHED = "FINISHED";
    public static final String STATUS_MISSED = "MISSED";
    public static final String STATUS_ERROR = "ERROR";
    private static final String SELF_LINK = "self";
    private static final String PROCESS_LINK = "process";
    private static final String INTEGRATION_LINK = "integration";
    private final Integer id;
    private final Map<String, Long> startTimes;
    private final String status;
    private final String processId;
    private final Map<String, String> links;

    public Reload(Map<String, Long> startTimes) {
        this(null, startTimes, null, null, null);
    }

    @JsonCreator
    public Reload(@JsonProperty(value="id") Integer id, @JsonProperty(value="startTimes") Map<String, Long> startTimes, @JsonProperty(value="status") String status, @JsonProperty(value="processId") String processId, @JsonProperty(value="links") Map<String, String> links) {
        this.id = id;
        this.startTimes = startTimes;
        this.status = status;
        this.processId = processId;
        this.links = links;
    }

    public Integer getId() {
        return this.id;
    }

    public Map<String, Long> getStartTimes() {
        return this.startTimes;
    }

    @JsonIgnore
    public Long getChatsStartTime() {
        return this.startTimes.get(CHATS_START_TIME_PROPERTY);
    }

    @JsonIgnore
    public Long getAgentTimelineStartTime() {
        return this.startTimes.get(AGENT_TIMELINE_START_TIME_PROPERTY);
    }

    public String getStatus() {
        return this.status;
    }

    public String getProcessId() {
        return this.processId;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public Optional<String> getUri() {
        return this.getLink(SELF_LINK);
    }

    @JsonIgnore
    public Optional<String> getProcessUri() {
        return this.getLink(PROCESS_LINK);
    }

    @JsonIgnore
    public Optional<String> getIntegrationUri() {
        return this.getLink(INTEGRATION_LINK);
    }

    private Optional<String> getLink(String linkName) {
        return this.links != null ? Optional.ofNullable(this.links.get(linkName)) : Optional.empty();
    }
}

