/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.sdk.model.executeafm.afm.filter.UriAttributeFilterElements;
import com.gooddata.sdk.model.executeafm.afm.filter.ValueAttributeFilterElements;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public interface AttributeFilterElements {
    public List<String> getElements();

    public static class Deserializer
    extends JsonDeserializer<AttributeFilterElements> {
        public AttributeFilterElements deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jp.readValueAsTree();
            switch (node.getNodeType()) {
                case ARRAY: {
                    return new UriAttributeFilterElements(Deserializer.nodeToElements(node));
                }
                case OBJECT: {
                    JsonNode uris = node.findValue("uris");
                    if (uris != null) {
                        return new UriAttributeFilterElements(Deserializer.nodeToElements(uris));
                    }
                    JsonNode values = node.findValue("values");
                    if (values != null) {
                        return new ValueAttributeFilterElements(Deserializer.nodeToElements(values));
                    }
                    throw JsonMappingException.from((JsonParser)jp, (String)"Unknown type of AttributeFilterElements");
                }
            }
            throw JsonMappingException.from((JsonParser)jp, (String)("Unknown value of type: " + String.valueOf(jp.currentToken())));
        }

        private static List<String> nodeToElements(JsonNode node) {
            return StreamSupport.stream(node.spliterator(), false).map(JsonNode::textValue).collect(Collectors.toList());
        }
    }

    public static class Serializer
    extends JsonSerializer<AttributeFilterElements> {
        public void serialize(AttributeFilterElements elements, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
            if (elements instanceof UriAttributeFilterElements) {
                Serializer.serializeWrapped("uris", elements, jg, serializerProvider);
            } else if (elements instanceof ValueAttributeFilterElements) {
                Serializer.serializeWrapped("values", elements, jg, serializerProvider);
            } else {
                serializerProvider.defaultSerializeValue(elements.getElements(), jg);
            }
        }

        private static void serializeWrapped(String name, AttributeFilterElements elements, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
            jg.writeStartObject();
            serializerProvider.defaultSerializeField(name, elements.getElements(), jg);
            jg.writeEndObject();
        }
    }
}

