/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm;

import com.gooddata.sdk.common.util.Validate;
import java.util.List;
import java.util.stream.Collectors;

public class ResultPage {
    private final List<Integer> offsets;
    private final List<Integer> limits;

    public ResultPage(List<Integer> offsets, List<Integer> limits) {
        this.offsets = (List)Validate.notEmpty(offsets, (String)"offsets");
        this.limits = (List)Validate.notEmpty(limits, (String)"limits");
        if (offsets.size() != limits.size()) {
            throw new IllegalArgumentException("Offsets and limits can't have different size.");
        }
    }

    private static String toQueryParam(List<Integer> list) {
        return list.stream().map(String::valueOf).collect(Collectors.joining("%2C"));
    }

    public String getOffsetsQueryParam() {
        return ResultPage.toQueryParam(this.offsets);
    }

    public String getLimitsQueryParam() {
        return ResultPage.toQueryParam(this.limits);
    }
}

