/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.Obj;
import com.gooddata.sdk.model.util.UriHelper;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;

public abstract class AbstractObj
implements Serializable {
    private static final long serialVersionUID = 2910760851810495274L;
    @JsonProperty(value="meta")
    protected final Meta meta;

    protected AbstractObj(@JsonProperty(value="meta") Meta meta) {
        this.meta = meta;
    }

    @SafeVarargs
    protected static <T extends Obj> String[] uris(T ... objs) {
        Validate.noNullElements((Object[])objs, (String)"objs");
        String[] uris = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            uris[i] = objs[i].getUri();
        }
        return uris;
    }

    @JsonIgnore
    public String getId() {
        return UriHelper.getLastUriPart(this.getUri());
    }

    @JsonIgnore
    public String getAuthor() {
        return this.meta.getAuthor();
    }

    @JsonIgnore
    public String getContributor() {
        return this.meta.getContributor();
    }

    @JsonIgnore
    public ZonedDateTime getCreated() {
        return this.meta.getCreated();
    }

    @JsonIgnore
    public String getSummary() {
        return this.meta.getSummary();
    }

    public void setSummary(String summary) {
        this.meta.setSummary(summary);
    }

    @JsonIgnore
    public String getTitle() {
        return this.meta.getTitle();
    }

    public void setTitle(String title) {
        this.meta.setTitle(title);
    }

    @JsonIgnore
    public ZonedDateTime getUpdated() {
        return this.meta.getUpdated();
    }

    @JsonIgnore
    public String getCategory() {
        return this.meta.getCategory();
    }

    public void setCategory(String category) {
        this.meta.setCategory(category);
    }

    @JsonIgnore
    public Set<String> getTags() {
        return this.meta.getTags();
    }

    public void setTags(Set<String> tags) {
        this.meta.setTags(tags);
    }

    @JsonIgnore
    public String getUri() {
        return this.meta.getUri();
    }

    @JsonIgnore
    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.meta.isDeprecated());
    }

    public void setDeprecated(Boolean deprecated) {
        this.meta.setDeprecated(deprecated);
    }

    @JsonIgnore
    public String getIdentifier() {
        return this.meta.getIdentifier();
    }

    public void setIdentifier(String identifier) {
        this.meta.setIdentifier(identifier);
    }

    @JsonIgnore
    public boolean isLocked() {
        return Boolean.TRUE.equals(this.meta.isLocked());
    }

    public void setLocked(Boolean locked) {
        this.meta.setLocked(locked);
    }

    @JsonIgnore
    public boolean isUnlisted() {
        return Boolean.TRUE.equals(this.meta.isUnlisted());
    }

    public void setUnlisted(Boolean unlisted) {
        this.meta.setUnlisted(unlisted);
    }

    @JsonIgnore
    public boolean isProduction() {
        return Boolean.TRUE.equals(this.meta.isProduction());
    }

    public void setProduction(Boolean production) {
        this.meta.setProduction(production);
    }

    @JsonIgnore
    public boolean isSharedWithSomeone() {
        return Boolean.TRUE.equals(this.meta.isSharedWithSomeone());
    }

    public void setSharedWithSomeone(Boolean sharedWithSomeone) {
        this.meta.setSharedWithSomeone(sharedWithSomeone);
    }

    @JsonIgnore
    public Set<String> getFlags() {
        return this.meta.getFlags();
    }

    public void setFlags(Set<String> flags) {
        this.meta.setFlags(flags);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

