/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="schema")
@JsonIgnoreProperties(ignoreUnknown=true)
public class WarehouseSchema {
    public static final String URI = "/gdc/datawarehouse/instances/{id}/schemas/{name}";
    private static final String SELF_LINK = "self";
    private static final String INSTANCE_LINK = "instance";
    private final String name;
    private final String description;
    private final Map<String, String> links;

    @JsonCreator
    private WarehouseSchema(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="links") Map<String, String> links) {
        this.name = name;
        this.description = description;
        this.links = links;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getInstanceUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(INSTANCE_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

