/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Expression;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.md.Updatable;
import java.util.Arrays;
import java.util.Collection;

@JsonTypeName(value="fact")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Fact
extends AbstractObj
implements Queryable,
Updatable {
    @JsonProperty(value="content")
    private final Content content;

    @JsonCreator
    private Fact(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    Fact(String title, String data, String type) {
        super(new Meta(title));
        this.content = new Content(Arrays.asList(new Expression(data, type)));
    }

    @JsonIgnore
    public Collection<Expression> getExpressions() {
        return this.content.getExpression();
    }

    private static class Content {
        @JsonProperty(value="expr")
        private final Collection<Expression> expression;

        @JsonCreator
        public Content(@JsonProperty(value="expr") Collection<Expression> expression) {
            this.expression = expression;
        }

        public Collection<Expression> getExpression() {
            return this.expression;
        }
    }
}

