/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.project.Environment;
import com.gooddata.util.ISODateTimeDeserializer;
import com.gooddata.util.ISODateTimeSerializer;
import com.gooddata.util.Validate;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="instance")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Warehouse {
    private static final String ID_PARAM = "id";
    public static final String URI = "/gdc/datawarehouse/instances/{id}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/datawarehouse/instances/{id}");
    public static final UriTemplate JDBC_CONNECTION_TEMPLATE = new UriTemplate("jdbc:gdc:datawarehouse://{host}:{port}/gdc/datawarehouse/instances/{id}");
    private static final String SELF_LINK = "self";
    private static final String STATUS_ENABLED = "ENABLED";
    private String title;
    private String description;
    private String authorizationToken;
    private DateTime created;
    private DateTime updated;
    private String createdBy;
    private String updatedBy;
    private String status;
    private String environment;
    private Map<String, String> links;
    private String warehouseHost;
    private int warehousePort = 443;

    public Warehouse(String title, String authToken) {
        this(title, authToken, null);
    }

    public Warehouse(String title, String authToken, String description) {
        this.title = Validate.notNull(title, "title");
        this.authorizationToken = authToken;
        this.description = description;
    }

    @JsonCreator
    public Warehouse(@JsonProperty(value="title") String title, @JsonProperty(value="authorizationToken") String authToken, @JsonProperty(value="description") String description, @JsonProperty(value="created") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime created, @JsonProperty(value="updated") @JsonDeserialize(using=ISODateTimeDeserializer.class) DateTime updated, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="updatedBy") String updatedBy, @JsonProperty(value="status") String status, @JsonProperty(value="environment") String environment, @JsonProperty(value="links") Map<String, String> links) {
        this(title, authToken, description);
        this.created = created;
        this.updated = updated;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.status = status;
        this.environment = environment;
        this.links = links;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    public DateTime getCreated() {
        return this.created;
    }

    @JsonSerialize(using=ISODateTimeSerializer.class, include=JsonSerialize.Inclusion.NON_NULL)
    public DateTime getUpdated() {
        return this.updated;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getStatus() {
        return this.status;
    }

    void setWarehouseHost(String warehouseHost) {
        this.warehouseHost = warehouseHost;
    }

    void setWarehousePort(int warehousePort) {
        this.warehousePort = warehousePort;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    @JsonIgnore
    public void setEnvironment(Environment environment) {
        Validate.notNull(environment, "environment");
        this.setEnvironment(environment.name());
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getJdbcConnectionString() {
        if (this.warehouseHost == null) {
            throw new IllegalStateException("Please set warehouseHost to be able to construct jdbc connection string");
        }
        return JDBC_CONNECTION_TEMPLATE.expand(new Object[]{this.warehouseHost, this.warehousePort, this.getId()}).toString();
    }

    @JsonIgnore
    public String getUri() {
        return this.links != null ? this.links.get(SELF_LINK) : null;
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get(ID_PARAM);
    }

    @JsonIgnore
    public boolean isEnabled() {
        return STATUS_ENABLED.equals(this.status);
    }
}

