/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="accountSetting")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Account {
    public static final String URI = "/gdc/account/profile/{id}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/account/profile/{id}");
    public static final String LOGIN_URI = "/gdc/account/login/{id}";
    public static final UriTemplate LOGIN_TEMPLATE = new UriTemplate("/gdc/account/login/{id}");
    public static final String CURRENT_ID = "current";
    private final String firstName;
    private final String lastName;
    @JsonIgnore
    private final Links links;

    @JsonCreator
    public Account(@JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="links") Links links) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.links = links;
    }

    Account(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.links = null;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    @JsonIgnore
    public String getUri() {
        return this.links.getSelf();
    }

    @JsonIgnore
    public String getProjectsLink() {
        return this.links.getProjects();
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("id");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Links {
        private final String self;
        private final String projects;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self, @JsonProperty(value="projects") String projects) {
            this.self = self;
            this.projects = projects;
        }

        public String getSelf() {
            return this.self;
        }

        public String getProjects() {
            return this.projects;
        }
    }
}

