/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata;

import com.gooddata.util.Validate;
import java.net.URI;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class UriPrefixer {
    private final URI uriPrefix;

    public UriPrefixer(URI uriPrefix) {
        this.uriPrefix = Validate.notNull(uriPrefix, "uriPrefix");
    }

    public UriPrefixer(String uriPrefix) {
        this(URI.create(uriPrefix));
    }

    public URI getUriPrefix() {
        return this.uriPrefix;
    }

    public URI mergeUris(URI uri) {
        Validate.notNull(uri, "uri");
        String path = StringUtils.trimTrailingCharacter((String)StringUtils.trimLeadingCharacter((String)uri.getRawPath(), (char)'/'), (char)'/');
        return UriComponentsBuilder.fromUri((URI)this.uriPrefix).pathSegment(new String[]{path}).query(uri.getRawQuery()).fragment(uri.getRawFragment()).build().toUri();
    }

    public URI mergeUris(String uri) {
        Validate.notEmpty(uri, "uri");
        return this.mergeUris(URI.create(uri));
    }
}

